/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops;

import java.util.ArrayList;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.DataOp;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.HopsException;
import org.apache.sysml.hops.MemoTable;
import org.apache.sysml.hops.MultiThreadedHop;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Aggregate;
import org.apache.sysml.lops.CombineUnary;
import org.apache.sysml.lops.CumulativeOffsetBinary;
import org.apache.sysml.lops.CumulativePartialAggregate;
import org.apache.sysml.lops.CumulativeSplitAggregate;
import org.apache.sysml.lops.Data;
import org.apache.sysml.lops.Group;
import org.apache.sysml.lops.Lop;
import org.apache.sysml.lops.LopProperties;
import org.apache.sysml.lops.PartialAggregate;
import org.apache.sysml.lops.PickByCount;
import org.apache.sysml.lops.SortKeys;
import org.apache.sysml.lops.Unary;
import org.apache.sysml.lops.UnaryCP;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;

public class UnaryOp
extends MultiThreadedHop {
    private Hop.OpOp1 _op = null;

    private UnaryOp() {
    }

    public UnaryOp(String l, Expression.DataType dt, Expression.ValueType vt, Hop.OpOp1 o, Hop inp) {
        super(l, dt, vt);
        this.getInput().add(0, inp);
        inp.getParent().add(this);
        this._op = o;
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
        HopsException.check(this._input.size() == 1, this, "should have arity 1 but has arity %d", this._input.size());
    }

    public Hop.OpOp1 getOp() {
        return this._op;
    }

    @Override
    public String getOpString() {
        String s = new String("");
        s = s + "u(" + this._op.toString().toLowerCase() + ")";
        return s;
    }

    @Override
    public boolean isGPUEnabled() {
        boolean isScalar;
        if (!DMLScript.USE_ACCELERATOR) {
            return false;
        }
        boolean bl = isScalar = this.getDataType() == Expression.DataType.SCALAR || this._op == Hop.OpOp1.CAST_AS_MATRIX && this.getInput().get(0).getDataType() == Expression.DataType.SCALAR || this._op == Hop.OpOp1.CAST_AS_FRAME && this.getInput().get(0).getDataType() == Expression.DataType.SCALAR;
        if (!isScalar) {
            switch (this._op) {
                case EXP: 
                case SQRT: 
                case LOG: 
                case ABS: 
                case ROUND: 
                case FLOOR: 
                case CEIL: 
                case SIN: 
                case COS: 
                case TAN: 
                case ASIN: 
                case ACOS: 
                case ATAN: 
                case SINH: 
                case COSH: 
                case TANH: 
                case SIGN: 
                case SIGMOID: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Hop input = this.getInput().get(0);
            if (this.getDataType() == Expression.DataType.SCALAR || this._op == Hop.OpOp1.CAST_AS_MATRIX && this.getInput().get(0).getDataType() == Expression.DataType.SCALAR || this._op == Hop.OpOp1.CAST_AS_FRAME && this.getInput().get(0).getDataType() == Expression.DataType.SCALAR) {
                if (this._op == Hop.OpOp1.IQM) {
                    Lop iqmLop = this.constructLopsIQM();
                    this.setLops(iqmLop);
                } else if (this._op == Hop.OpOp1.MEDIAN) {
                    Lop medianLop = this.constructLopsMedian();
                    this.setLops(medianLop);
                } else {
                    UnaryCP.OperationTypes optype = (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)this._op));
                    if (optype == null) {
                        throw new HopsException("Unknown UnaryCP lop type for UnaryOp operation type '" + (Object)((Object)this._op) + "'");
                    }
                    UnaryCP unary1 = new UnaryCP(input.constructLops(), optype, this.getDataType(), this.getValueType());
                    this.setOutputDimensions(unary1);
                    this.setLineNumbers(unary1);
                    this.setLops(unary1);
                }
            } else {
                LopProperties.ExecType et = this.optFindExecType();
                if (this.isCumulativeUnaryOperation() && et != LopProperties.ExecType.CP && et != LopProperties.ExecType.GPU) {
                    Lop cumsumLop = null;
                    cumsumLop = et == LopProperties.ExecType.MR ? this.constructLopsMRCumulativeUnary() : this.constructLopsSparkCumulativeUnary();
                    this.setLops(cumsumLop);
                } else {
                    int k = this.isCumulativeUnaryOperation() || this.isExpensiveUnaryOperation() ? OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads) : 1;
                    Unary unary1 = new Unary(input.constructLops(), (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._op)), this.getDataType(), this.getValueType(), et, k);
                    this.setOutputDimensions(unary1);
                    this.setLineNumbers(unary1);
                    this.setLops(unary1);
                }
            }
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "error constructing Lops for UnaryOp Hop -- \n ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    private Lop constructLopsMedian() {
        LopProperties.ExecType et = this.optFindExecType();
        if (et == LopProperties.ExecType.MR) {
            CombineUnary combine = CombineUnary.constructCombineLop(this.getInput().get(0).constructLops(), this.getDataType(), this.getValueType());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, et);
            combine.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
            LopProperties.ExecType et_pick = LopProperties.ExecType.CP;
            PickByCount pick = new PickByCount(sort, Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.5)), this.getDataType(), this.getValueType(), PickByCount.OperationTypes.MEDIAN, et_pick, false);
            pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            this.setLineNumbers(pick);
            return pick;
        }
        SortKeys sort = SortKeys.constructSortByValueLop(this.getInput().get(0).constructLops(), SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, et);
        sort.getOutputParameters().setDimensions(this.getInput().get(0).getDim1(), this.getInput().get(0).getDim2(), this.getInput().get(0).getRowsInBlock(), this.getInput().get(0).getColsInBlock(), this.getInput().get(0).getNnz());
        PickByCount pick = new PickByCount(sort, Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.5)), this.getDataType(), this.getValueType(), PickByCount.OperationTypes.MEDIAN, et, true);
        pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
        this.setLineNumbers(pick);
        this.setLops(pick);
        return pick;
    }

    private Lop constructLopsIQM() {
        LopProperties.ExecType et = this.optFindExecType();
        Hop input = this.getInput().get(0);
        if (et == LopProperties.ExecType.MR) {
            CombineUnary combine = CombineUnary.constructCombineLop(input.constructLops(), Expression.DataType.MATRIX, this.getValueType());
            combine.getOutputParameters().setDimensions(input.getDim1(), input.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), input.getNnz());
            SortKeys sort = SortKeys.constructSortByValueLop(combine, SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.MR);
            sort.getOutputParameters().setDimensions(input.getDim1(), input.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), input.getNnz());
            Data lit = Data.createLiteralLop(Expression.ValueType.DOUBLE, Double.toString(0.25));
            lit.setAllPositions(this.getFilename(), this.getBeginLine(), this.getBeginColumn(), this.getEndLine(), this.getEndColumn());
            PickByCount pick = new PickByCount(sort, lit, Expression.DataType.MATRIX, this.getValueType(), PickByCount.OperationTypes.RANGEPICK);
            pick.getOutputParameters().setDimensions(-1L, -1L, this.getRowsInBlock(), this.getColsInBlock(), -1L);
            this.setLineNumbers(pick);
            PartialAggregate pagg = new PartialAggregate(pick, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), (PartialAggregate.DirectionTypes)((Object)HopsDirection2Lops.get((Object)Hop.Direction.RowCol)), Expression.DataType.MATRIX, this.getValueType());
            this.setLineNumbers(pagg);
            pagg.setDimensionsBasedOnDirection(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock());
            Group group1 = new Group(pagg, Group.OperationTypes.Sort, Expression.DataType.MATRIX, this.getValueType());
            group1.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            this.setLineNumbers(group1);
            Aggregate agg1 = new Aggregate(group1, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), Expression.DataType.MATRIX, this.getValueType(), LopProperties.ExecType.MR);
            agg1.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
            agg1.setupCorrectionLocation(pagg.getCorrectionLocation());
            this.setLineNumbers(agg1);
            UnaryCP unary1 = new UnaryCP(agg1, (UnaryCP.OperationTypes)((Object)HopsOpOp1LopsUS.get((Object)Hop.OpOp1.CAST_AS_SCALAR)), this.getDataType(), this.getValueType());
            unary1.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(unary1);
            Unary iqm = new Unary((Lop)sort, unary1, Unary.OperationTypes.MR_IQM, Expression.DataType.SCALAR, Expression.ValueType.DOUBLE, LopProperties.ExecType.CP);
            iqm.getOutputParameters().setDimensions(0L, 0L, 0L, 0L, -1L);
            this.setLineNumbers(iqm);
            return iqm;
        }
        SortKeys sort = SortKeys.constructSortByValueLop(input.constructLops(), SortKeys.OperationTypes.WithoutWeights, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, et);
        sort.getOutputParameters().setDimensions(input.getDim1(), input.getDim2(), input.getRowsInBlock(), input.getColsInBlock(), input.getNnz());
        PickByCount pick = new PickByCount(sort, null, this.getDataType(), this.getValueType(), PickByCount.OperationTypes.IQM, et, true);
        pick.getOutputParameters().setDimensions(this.getDim1(), this.getDim2(), this.getRowsInBlock(), this.getColsInBlock(), this.getNnz());
        this.setLineNumbers(pick);
        return pick;
    }

    private Lop constructLopsMRCumulativeUnary() {
        Lop X;
        Hop input = this.getInput().get(0);
        long rlen = input.getDim1();
        long clen = input.getDim2();
        long brlen = input.getRowsInBlock();
        long bclen = input.getColsInBlock();
        boolean force = !this.dimsKnown() || this._etypeForced == LopProperties.ExecType.MR;
        Aggregate.OperationTypes aggtype = this.getCumulativeAggType();
        Lop TEMP = X = input.constructLops();
        ArrayList<Lop> DATA = new ArrayList<Lop>();
        int level = 0;
        while ((double)(2L * OptimizerUtils.estimateSize(TEMP.getOutputParameters().getNumRows(), clen) + OptimizerUtils.estimateSize(1L, clen)) > OptimizerUtils.getLocalMemBudget() && TEMP.getOutputParameters().getNumRows() > 1L || force) {
            DATA.add(TEMP);
            long rlenAgg = (long)Math.ceil((double)TEMP.getOutputParameters().getNumRows() / (double)brlen);
            CumulativePartialAggregate preagg = new CumulativePartialAggregate(TEMP, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, aggtype, LopProperties.ExecType.MR);
            preagg.getOutputParameters().setDimensions(rlenAgg, clen, brlen, bclen, -1L);
            this.setLineNumbers(preagg);
            Group group = new Group(preagg, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            group.getOutputParameters().setDimensions(rlenAgg, clen, brlen, bclen, -1L);
            this.setLineNumbers(group);
            Aggregate agg = new Aggregate(group, (Aggregate.OperationTypes)((Object)HopsAgg2Lops.get((Object)Hop.AggOp.SUM)), this.getDataType(), this.getValueType(), LopProperties.ExecType.MR);
            agg.getOutputParameters().setDimensions(rlenAgg, clen, brlen, bclen, -1L);
            agg.setupCorrectionLocation(PartialAggregate.CorrectionLocationType.NONE);
            this.setLineNumbers(agg);
            TEMP = agg;
            ++level;
            force = false;
        }
        if (TEMP.getOutputParameters().getNumRows() != 1L) {
            int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
            Unary unary1 = new Unary(TEMP, (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._op)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.CP, k);
            unary1.getOutputParameters().setDimensions(TEMP.getOutputParameters().getNumRows(), clen, brlen, bclen, -1L);
            this.setLineNumbers(unary1);
            TEMP = unary1;
        }
        while (level-- > 0) {
            double init = this.getCumulativeInitValue();
            CumulativeSplitAggregate split = new CumulativeSplitAggregate(TEMP, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, init);
            split.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, -1L);
            this.setLineNumbers(split);
            Group group1 = new Group((Lop)DATA.get(level), Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            group1.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, -1L);
            this.setLineNumbers(group1);
            Group group2 = new Group(split, Group.OperationTypes.Sort, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE);
            group2.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, -1L);
            this.setLineNumbers(group2);
            CumulativeOffsetBinary binary = new CumulativeOffsetBinary(group1, group2, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, aggtype, LopProperties.ExecType.MR);
            binary.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, -1L);
            this.setLineNumbers(binary);
            TEMP = binary;
        }
        return TEMP;
    }

    private Lop constructLopsSparkCumulativeUnary() {
        Lop X;
        Hop input = this.getInput().get(0);
        long rlen = input.getDim1();
        long clen = input.getDim2();
        long brlen = input.getRowsInBlock();
        long bclen = input.getColsInBlock();
        boolean force = !this.dimsKnown() || this._etypeForced == LopProperties.ExecType.SPARK;
        Aggregate.OperationTypes aggtype = this.getCumulativeAggType();
        Lop TEMP = X = input.constructLops();
        ArrayList<Lop> DATA = new ArrayList<Lop>();
        int level = 0;
        while ((double)(2L * OptimizerUtils.estimateSize(TEMP.getOutputParameters().getNumRows(), clen) + OptimizerUtils.estimateSize(1L, clen)) > OptimizerUtils.getLocalMemBudget() && TEMP.getOutputParameters().getNumRows() > 1L || force) {
            DATA.add(TEMP);
            long rlenAgg = (long)Math.ceil((double)TEMP.getOutputParameters().getNumRows() / (double)brlen);
            CumulativePartialAggregate preagg = new CumulativePartialAggregate(TEMP, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, aggtype, LopProperties.ExecType.SPARK);
            preagg.getOutputParameters().setDimensions(rlenAgg, clen, brlen, bclen, -1L);
            this.setLineNumbers(preagg);
            TEMP = preagg;
            ++level;
            force = false;
        }
        if (TEMP.getOutputParameters().getNumRows() != 1L) {
            int k = OptimizerUtils.getConstrainedNumThreads(this._maxNumThreads);
            Unary unary1 = new Unary(TEMP, (Unary.OperationTypes)((Object)HopsOpOp1LopsU.get((Object)this._op)), Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, LopProperties.ExecType.CP, k);
            unary1.getOutputParameters().setDimensions(TEMP.getOutputParameters().getNumRows(), clen, brlen, bclen, -1L);
            this.setLineNumbers(unary1);
            TEMP = unary1;
        }
        while (level-- > 0) {
            double initValue = this.getCumulativeInitValue();
            CumulativeOffsetBinary binary = new CumulativeOffsetBinary((Lop)DATA.get(level), TEMP, Expression.DataType.MATRIX, Expression.ValueType.DOUBLE, initValue, aggtype, LopProperties.ExecType.SPARK);
            binary.getOutputParameters().setDimensions(rlen, clen, brlen, bclen, -1L);
            this.setLineNumbers(binary);
            TEMP = binary;
        }
        return TEMP;
    }

    private Aggregate.OperationTypes getCumulativeAggType() {
        switch (this._op) {
            case CUMSUM: {
                return Aggregate.OperationTypes.KahanSum;
            }
            case CUMPROD: {
                return Aggregate.OperationTypes.Product;
            }
            case CUMSUMPROD: {
                return Aggregate.OperationTypes.SumProduct;
            }
            case CUMMIN: {
                return Aggregate.OperationTypes.Min;
            }
            case CUMMAX: {
                return Aggregate.OperationTypes.Max;
            }
        }
        return null;
    }

    private double getCumulativeInitValue() {
        switch (this._op) {
            case CUMSUM: 
            case CUMSUMPROD: {
                return 0.0;
            }
            case CUMPROD: {
                return 1.0;
            }
            case CUMMIN: {
                return Double.POSITIVE_INFINITY;
            }
            case CUMMAX: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return Double.NaN;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        super.computeMemEstimate(memo);
        if (this._op == Hop.OpOp1.NROW || this._op == Hop.OpOp1.NCOL) {
            this._memEstimate = 4.0;
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = -1.0;
        sparsity = this.isGPUEnabled() ? 1.0 : OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        double ret = 0.0;
        if (this._op == Hop.OpOp1.IQM || this._op == Hop.OpOp1.MEDIAN) {
            ret = this.getInput().get(0).getMemEstimate() * 3.0;
        }
        if (this.isGPUEnabled()) {
            ret += (double)OptimizerUtils.estimateSize(dim1, dim2);
        }
        return ret;
    }

    @Override
    protected long[] inferOutputCharacteristics(MemoTable memo) {
        long[] ret = null;
        Hop input = this.getInput().get(0);
        MatrixCharacteristics mc = memo.getAllInputStats(input);
        if (mc.dimsKnown()) {
            ret = this._op == Hop.OpOp1.ABS || this._op == Hop.OpOp1.COS || this._op == Hop.OpOp1.SIN || this._op == Hop.OpOp1.TAN || this._op == Hop.OpOp1.ACOS || this._op == Hop.OpOp1.ASIN || this._op == Hop.OpOp1.ATAN || this._op == Hop.OpOp1.COSH || this._op == Hop.OpOp1.SINH || this._op == Hop.OpOp1.TANH || this._op == Hop.OpOp1.SQRT || this._op == Hop.OpOp1.ROUND || this._op == Hop.OpOp1.SPROP ? new long[]{mc.getRows(), mc.getCols(), mc.getNonZeros()} : (this._op == Hop.OpOp1.CUMSUMPROD ? new long[]{mc.getRows(), 1L, -1L} : new long[]{mc.getRows(), mc.getCols(), -1L});
        }
        return ret;
    }

    @Override
    public boolean allowsAllExecTypes() {
        return true;
    }

    private boolean isInMemoryOperation() {
        return this._op == Hop.OpOp1.INVERSE;
    }

    public boolean isCumulativeUnaryOperation() {
        return this._op == Hop.OpOp1.CUMSUM || this._op == Hop.OpOp1.CUMPROD || this._op == Hop.OpOp1.CUMMIN || this._op == Hop.OpOp1.CUMMAX || this._op == Hop.OpOp1.CUMSUMPROD;
    }

    public boolean isCastUnaryOperation() {
        return this._op == Hop.OpOp1.CAST_AS_MATRIX || this._op == Hop.OpOp1.CAST_AS_SCALAR || this._op == Hop.OpOp1.CAST_AS_FRAME || this._op == Hop.OpOp1.CAST_AS_BOOLEAN || this._op == Hop.OpOp1.CAST_AS_DOUBLE || this._op == Hop.OpOp1.CAST_AS_INT;
    }

    public boolean isExpensiveUnaryOperation() {
        return this._op == Hop.OpOp1.EXP || this._op == Hop.OpOp1.LOG || this._op == Hop.OpOp1.SIGMOID;
    }

    @Override
    protected LopProperties.ExecType optFindExecType() {
        LopProperties.ExecType REMOTE;
        this.checkAndSetForcedPlatform();
        LopProperties.ExecType execType = REMOTE = OptimizerUtils.isSparkExecutionMode() ? LopProperties.ExecType.SPARK : LopProperties.ExecType.MR;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.getInput().get(0).areDimsBelowThreshold() || this.getInput().get(0).isVector() || this.isInMemoryOperation() ? LopProperties.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        if (this._etype == LopProperties.ExecType.CP && this._etypeForced != LopProperties.ExecType.CP && this.getInput().get(0).optFindExecType() == LopProperties.ExecType.SPARK && this.getDataType().isMatrix() && !this.isCumulativeUnaryOperation() && !this.isCastUnaryOperation() && this._op != Hop.OpOp1.MEDIAN && this._op != Hop.OpOp1.IQM && !(this.getInput().get(0) instanceof DataOp) && this.getInput().get(0).getParent().size() == 1) {
            this._etype = LopProperties.ExecType.SPARK;
        }
        this.setRequiresRecompileIfNecessary();
        if (this._op == Hop.OpOp1.PRINT || this._op == Hop.OpOp1.ASSERT || this._op == Hop.OpOp1.STOP || this._op == Hop.OpOp1.INVERSE || this._op == Hop.OpOp1.EIGEN || this._op == Hop.OpOp1.CHOLESKY || this._op == Hop.OpOp1.SVD || this.getInput().get(0).getDataType() == Expression.DataType.LIST) {
            this._etype = LopProperties.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    public void refreshSizeInformation() {
        Hop input = this.getInput().get(0);
        if (this.getDataType() != Expression.DataType.SCALAR) {
            if ((this._op == Hop.OpOp1.CAST_AS_MATRIX || this._op == Hop.OpOp1.CAST_AS_FRAME || this._op == Hop.OpOp1.CAST_AS_SCALAR) && input.getDataType() == Expression.DataType.LIST) {
                this.setDim1(input.getLength() > 1L ? input.getLength() : -1L);
                this.setDim2(input.getLength() > 1L ? 1L : -1L);
            } else if ((this._op == Hop.OpOp1.CAST_AS_MATRIX || this._op == Hop.OpOp1.CAST_AS_FRAME) && input.getDataType() == Expression.DataType.SCALAR) {
                this.setDim1(1L);
                this.setDim2(1L);
            } else if (this._op == Hop.OpOp1.CUMSUMPROD) {
                this.setDim1(input.getDim1());
                this.setDim2(1L);
            } else {
                this.setDim1(input.getDim1());
                this.setDim2(input.getDim2());
                if (this._op == Hop.OpOp1.ABS || this._op == Hop.OpOp1.SIN || this._op == Hop.OpOp1.TAN || this._op == Hop.OpOp1.SINH || this._op == Hop.OpOp1.TANH || this._op == Hop.OpOp1.ASIN || this._op == Hop.OpOp1.ATAN || this._op == Hop.OpOp1.SQRT || this._op == Hop.OpOp1.ROUND || this._op == Hop.OpOp1.SPROP) {
                    this.setNnz(input.getNnz());
                }
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UnaryOp ret = new UnaryOp();
        ret.clone(this, false);
        ret._op = this._op;
        return ret;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof UnaryOp)) {
            return false;
        }
        if (this._op == Hop.OpOp1.PRINT) {
            return false;
        }
        UnaryOp that2 = (UnaryOp)that;
        return this._op == that2._op && this.getInput().get(0) == that2.getInput().get(0);
    }
}

