/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.support;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aopalliance.aop.AspectException;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.IntroductionInfo;
import org.springframework.util.ClassUtils;

public class IntroductionInfoSupport
implements IntroductionInfo,
Serializable {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    protected Set publishedInterfaces = new HashSet();

    public void suppressInterface(Class intf) {
        this.publishedInterfaces.remove(intf);
    }

    public Class[] getInterfaces() {
        return this.publishedInterfaces.toArray(new Class[this.publishedInterfaces.size()]);
    }

    public boolean implementsInterface(Class intf) {
        Iterator it = this.publishedInterfaces.iterator();
        while (it.hasNext()) {
            Class pubIntf = (Class)it.next();
            if (!intf.isInterface() || !intf.isAssignableFrom(pubIntf)) continue;
            return true;
        }
        return false;
    }

    protected void implementInterfacesOnObject(Object delegate) {
        this.publishedInterfaces.addAll(ClassUtils.getAllInterfacesAsSet((Object)delegate));
    }

    protected final boolean isMethodOnIntroducedInterface(MethodInvocation mi) {
        return this.implementsInterface(mi.getMethod().getDeclaringClass());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new AspectException("Failed to deserialize Spring DelegatingIntroductionInterceptor: check that Spring AOP libraries and implementation class for the introduction are available on the client side");
        }
        this.logger = LogFactory.getLog(this.getClass());
    }
}

