/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.utils.conn.logging;

import java.io.IOException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.NHttpMessageParserFactory;
import org.apache.http.nio.NHttpMessageWriterFactory;
import org.apache.http.nio.reactor.IOSession;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.synapse.transport.utils.conn.SynapseNHttpClientConnection;

public class LoggingNHttpClientConnection
extends SynapseNHttpClientConnection {
    private final Log log;

    public LoggingNHttpClientConnection(IOSession session, int bufferSize, int fragmentSizeHint, ByteBufferAllocator allocator, CharsetDecoder charDecoder, CharsetEncoder charEncoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, NHttpMessageParserFactory<HttpResponse> responseParserFactory, Log log) {
        super(session, bufferSize, fragmentSizeHint, allocator, charDecoder, charEncoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        this.log = log;
    }

    @Override
    public void close() throws IOException {
        this.log.debug((Object)"Close connection");
        super.close();
    }

    @Override
    public void shutdown() throws IOException {
        this.log.debug((Object)"Shutdown connection");
        super.shutdown();
    }

    @Override
    public void submitRequest(HttpRequest request) throws IOException, HttpException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + (Object)((Object)this) + ": " + request.getRequestLine().toString()));
        }
        super.submitRequest(request);
    }

    @Override
    public void consumeInput(NHttpClientEventHandler handler) {
        this.log.debug((Object)"Consume input");
        super.consumeInput(handler);
    }

    @Override
    public void produceOutput(NHttpClientEventHandler handler) {
        this.log.debug((Object)"Produce output");
        super.produceOutput(handler);
    }
}

