/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.commons.jmx;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.commons.jmx.ThreadingViewMBean;

public class ThreadingView
implements ThreadingViewMBean {
    private static final String SYNAPSE_THREADING_VIEW = "Threading";
    private static final int SHORT_SAMPLING_PERIOD = 2;
    private static final int LONG_SAMPLING_PERIOD = 300;
    private static final int SAMPLES_PER_MINUTE = 30;
    private static final int SAMPLES_PER_HOUR = 12;
    private String threadNamePrefix = null;
    private boolean periodicLogs = false;
    private double alertMargin = -1.0;
    private double avgBlockedWorkerPercentage = 0.0;
    private double avgUnblockedWorkerPercentage = 0.0;
    private Queue<Double> shortTermDataQueue = new LinkedList<Double>();
    private Queue<Double> longTermDataQueue = new LinkedList<Double>();
    private int samplesCount = 0;
    private int totalCount = 0;
    private Date resetTime = Calendar.getInstance().getTime();
    private static final Log log = LogFactory.getLog(ThreadingView.class);
    private static final ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    private ScheduledExecutorService scheduler;

    public ThreadingView(final String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-thread-view");
            }
        });
        this.initMBean();
    }

    public ThreadingView(String threadNamePrefix, boolean periodicLogs, double alertMargin) {
        this(threadNamePrefix);
        this.periodicLogs = periodicLogs;
        if (alertMargin > 0.0 && alertMargin < 100.0) {
            this.alertMargin = alertMargin;
        } else {
            log.warn((Object)("Invalid alert margin for the thread group: " + threadNamePrefix + " - Using default value"));
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-registering the Synapse threading view for the thread group: " + this.threadNamePrefix));
        }
        MBeanRegistrar.getInstance().unRegisterMBean(SYNAPSE_THREADING_VIEW, this.threadNamePrefix);
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    private void initMBean() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting a new Synapse threading view for the thread group: " + this.threadNamePrefix));
        }
        this.scheduler.scheduleAtFixedRate(new ThreadingDataCollectorTask(), 2L, 2L, TimeUnit.SECONDS);
        this.scheduler.scheduleAtFixedRate(new LongTermDataCollectorTask(), 300L, 300L, TimeUnit.SECONDS);
        boolean registered = false;
        try {
            registered = MBeanRegistrar.getInstance().registerMBean(this, SYNAPSE_THREADING_VIEW, this.threadNamePrefix);
        }
        finally {
            if (!registered) {
                this.scheduler.shutdownNow();
            }
        }
    }

    @Override
    public int getTotalWorkerCount() {
        ThreadInfo[] threadInfo;
        int count = 0;
        for (ThreadInfo ti : threadInfo = this.dumpAllThreads()) {
            if (ti == null || !ti.getThreadName().startsWith(this.threadNamePrefix)) continue;
            ++count;
        }
        return count;
    }

    private double getBlockedWorkerPercentage() {
        ThreadInfo[] threadInfo;
        int totalCount = 0;
        int blockedCount = 0;
        for (ThreadInfo ti : threadInfo = this.dumpAllThreads()) {
            if (ti == null || !ti.getThreadName().startsWith(this.threadNamePrefix)) continue;
            ++totalCount;
            if (!this.isBlocked(ti)) continue;
            ++blockedCount;
        }
        if (totalCount == 0) {
            return 0.0;
        }
        return (double)blockedCount / (double)totalCount * 100.0;
    }

    @Override
    public String[] getDeadLockedWorkers() {
        String[] workers = null;
        long[] threads = threadBean.findMonitorDeadlockedThreads();
        if (threads != null) {
            ThreadInfo[] threadInfo = threadBean.getThreadInfo(threads);
            workers = new String[threadInfo.length];
            for (int i = 0; i < threadInfo.length; ++i) {
                workers[i] = threadInfo[i] != null ? threadInfo[i].getThreadName() : null;
            }
        }
        return workers;
    }

    @Override
    public double getAvgBlockedWorkerPercentage() {
        return this.avgBlockedWorkerPercentage;
    }

    @Override
    public double getAvgUnblockedWorkerPercentage() {
        return this.avgUnblockedWorkerPercentage;
    }

    @Override
    public double getLastMinuteBlockedWorkerPercentage() {
        return this.getAverageBlockedThreads(1);
    }

    @Override
    public double getLast5MinuteBlockedWorkerPercentage() {
        return this.getAverageBlockedThreads(5);
    }

    @Override
    public double getLast15MinuteBlockedWorkerPercentage() {
        return this.getAverageBlockedThreads(15);
    }

    @Override
    public double getLastHourBlockedWorkerPercentage() {
        return this.getAverageBlockedThreadsByHour(1);
    }

    @Override
    public double getLast8HourBlockedWorkerPercentage() {
        return this.getAverageBlockedThreadsByHour(8);
    }

    @Override
    public double getLast24HourBlockedWorkerPercentage() {
        return this.getAverageBlockedThreadsByHour(24);
    }

    @Override
    public Date getLastResetTime() {
        return this.resetTime;
    }

    @Override
    public void reset() {
        this.avgBlockedWorkerPercentage = 0.0;
        this.avgUnblockedWorkerPercentage = 0.0;
        this.shortTermDataQueue.clear();
        this.longTermDataQueue.clear();
        this.samplesCount = 0;
        this.totalCount = 0;
        this.resetTime = Calendar.getInstance().getTime();
    }

    private boolean isBlocked(ThreadInfo threadInfo) {
        StackTraceElement[] stackTrace;
        Thread.State state = threadInfo.getThreadState();
        if (state.equals((Object)Thread.State.BLOCKED)) {
            return true;
        }
        return (state.equals((Object)Thread.State.WAITING) || state.equals((Object)Thread.State.TIMED_WAITING)) && (stackTrace = threadInfo.getStackTrace()).length > 0 && !"park".equals(stackTrace[0].getMethodName());
    }

    private ThreadInfo[] dumpAllThreads() {
        long[] ids = threadBean.getAllThreadIds();
        return threadBean.getThreadInfo(ids, 1);
    }

    private double getAverageBlockedThreads(int n) {
        int samples = n * 30;
        double sum = 0.0;
        Double[] array = this.shortTermDataQueue.toArray(new Double[this.shortTermDataQueue.size()]);
        if (samples > array.length) {
            samples = array.length;
            for (Double anArray : array) {
                sum += anArray.doubleValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += array[array.length - 1 - i].doubleValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }

    private double getAverageBlockedThreadsByHour(int n) {
        int samples = n * 12;
        double sum = 0.0;
        Double[] array = this.longTermDataQueue.toArray(new Double[this.longTermDataQueue.size()]);
        if (samples > array.length) {
            samples = array.length;
            for (Double anArray : array) {
                sum += anArray.doubleValue();
            }
        } else {
            for (int i = 0; i < samples; ++i) {
                sum += array[array.length - 1 - i].doubleValue();
            }
        }
        if (samples == 0) {
            return 0.0;
        }
        return sum / (double)samples;
    }

    private class LongTermDataCollectorTask
    implements Runnable {
        private LongTermDataCollectorTask() {
        }

        @Override
        public void run() {
            double blocked = ThreadingView.this.getBlockedWorkerPercentage();
            if (ThreadingView.this.longTermDataQueue.size() == 288) {
                ThreadingView.this.longTermDataQueue.remove();
            }
            ThreadingView.this.longTermDataQueue.offer(blocked);
        }
    }

    private class ThreadingDataCollectorTask
    implements Runnable {
        private ThreadingDataCollectorTask() {
        }

        @Override
        public void run() {
            ThreadingView.this.samplesCount++;
            double blocked = ThreadingView.this.getBlockedWorkerPercentage();
            double unblocked = 100.0 - blocked;
            ThreadingView.this.avgBlockedWorkerPercentage = (ThreadingView.this.avgBlockedWorkerPercentage * (double)ThreadingView.this.totalCount + blocked) / (double)(ThreadingView.this.totalCount + 1);
            ThreadingView.this.avgUnblockedWorkerPercentage = (ThreadingView.this.avgUnblockedWorkerPercentage * (double)ThreadingView.this.totalCount + unblocked) / (double)(ThreadingView.this.totalCount + 1);
            if (ThreadingView.this.shortTermDataQueue.size() == 450) {
                ThreadingView.this.shortTermDataQueue.remove();
            }
            ThreadingView.this.shortTermDataQueue.offer(blocked);
            if (ThreadingView.this.samplesCount == 30) {
                ThreadingView.this.samplesCount = 0;
                this.periodicDump();
            }
            ThreadingView.this.totalCount++;
        }

        private void periodicDump() {
            double blocked;
            if (ThreadingView.this.periodicLogs && log.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Thread state summary for ").append(ThreadingView.this.threadNamePrefix).append(" threads - Blocked: ").append(ThreadingView.this.avgBlockedWorkerPercentage).append("%, Unblocked: ").append(ThreadingView.this.avgUnblockedWorkerPercentage).append("%");
                log.debug((Object)buffer.toString());
            }
            if (ThreadingView.this.alertMargin > 0.0 && (blocked = ThreadingView.this.getAverageBlockedThreads(1)) > ThreadingView.this.alertMargin) {
                log.warn((Object)("SYSTEM ALERT: " + blocked + "% of the " + ThreadingView.this.threadNamePrefix + " threads were in BLOCKED state during last minute!"));
            }
        }
    }
}

