/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import com.rabbitmq.client.Address;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportMessage;

public final class AMQPTransportUtils {
    private static final Log log = LogFactory.getLog(AMQPTransportUtils.class);
    private static Properties prop = AMQPTransportUtils.loadProperties("amqp-transport.properties");

    private static Properties loadProperties(String filePath) {
        InputStream in;
        Properties properties = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading a file '" + filePath + "' from classpath"));
        }
        if ((in = cl.getResourceAsStream(filePath)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
            filePath = "repository/conf" + File.separatorChar + filePath;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading a file '" + filePath + "' from classpath"));
            }
            if ((in = cl.getResourceAsStream(filePath)) == null && log.isDebugEnabled()) {
                log.debug((Object)("Unable to load file  ' " + filePath + " '"));
            }
        }
        if (in != null) {
            try {
                properties.load(in);
            }
            catch (IOException e) {
                String msg = "Error loading properties from a file at :" + filePath;
                log.error((Object)msg, (Throwable)e);
            }
        }
        return properties;
    }

    public static String getStringProperty(String name, String def) throws NumberFormatException {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : (String)prop.get(name)) : val;
    }

    public static int getIntProperty(String name, int def) throws NumberFormatException {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Integer.parseInt((String)prop.get(name))) : Integer.parseInt(val);
    }

    public static long getLongProperty(String name, long def) throws NumberFormatException {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Long.parseLong((String)prop.get(name))) : Long.parseLong(val);
    }

    public static double getDoubleProperty(String name, double def) throws NumberFormatException {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Double.parseDouble((String)prop.get(name))) : Double.parseDouble(val);
    }

    public static Boolean getBooleanProperty(String name, boolean def) throws NumberFormatException {
        String val = System.getProperty(name);
        return val == null ? (prop.get(name) == null ? def : Boolean.parseBoolean((String)prop.get(name))) : Boolean.parseBoolean(val);
    }

    public static Map<String, String> getServiceStringParameters(List<Parameter> list) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Parameter p : list) {
            if (!(p.getValue() instanceof String)) continue;
            map.put(p.getName(), (String)p.getValue());
        }
        return map;
    }

    public static String getOptionalStringParameter(String key, Map<String, String> srcMap1, Map<String, String> srcMap2) {
        String value = srcMap1.get(key);
        if (value == null) {
            value = srcMap2.get(key);
        }
        return value;
    }

    public static Boolean getOptionalBooleanParameter(String key, Map<String, String> srcMap1, Map<String, String> srcMap2) {
        String value = srcMap1.get(key);
        if (value == null) {
            value = srcMap2.get(key);
        }
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public static Integer getOptionalIntParameter(String key, Map<String, String> srcMap1, Map<String, String> srcMap2) throws AMQPTransportException {
        String value = srcMap1.get(key);
        if (value == null) {
            value = srcMap2.get(key);
        }
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new AMQPTransportException("Invalid value '" + value + "' for the key '" + key + "'");
            }
        }
        return null;
    }

    public static Double getOptionalDoubleParameter(String key, Map<String, String> srcMap1, Map<String, String> srcMap2) throws AMQPTransportException {
        String value = srcMap1.get(key);
        if (value == null) {
            value = srcMap2.get(key);
        }
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new AMQPTransportException("Invalid value '" + value + "' for the key '" + key + "'");
            }
        }
        return null;
    }

    public static String[] split(String src, String delimiter) {
        return src.split(delimiter);
    }

    public static Address[] getAddressArray(String addressString, String regex, char subRegex) throws NumberFormatException {
        String[] hosts = addressString.split(regex);
        Address[] addresses = new Address[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            addresses[i] = new Address(hosts[i].substring(0, hosts[i].indexOf(subRegex)), Integer.parseInt(hosts[i].substring(hosts[i].indexOf(subRegex) + 1)));
        }
        return addresses;
    }

    public static void moveElements(BlockingQueue<AMQPTransportMessage> src, List<AMQPTransportMessage> dest, int blockSize) throws AMQPTransportException {
        try {
            src.drainTo(dest, blockSize);
        }
        catch (Exception e) {
            throw new AMQPTransportException(e.getMessage(), e);
        }
    }

    public static Map<String, String> parseAMQPUri(String amqpUri) throws AMQPTransportException {
        String[] values;
        HashMap<String, String> params = new HashMap<String, String>();
        String svcName = amqpUri.substring(7, amqpUri.indexOf(63));
        String kv = amqpUri.substring(amqpUri.indexOf(63) + 1);
        for (String str : values = kv.split("&")) {
            str = str.trim();
            params.put(str.substring(0, str.indexOf(61)), str.substring(str.indexOf(61) + 1));
        }
        if (!params.keySet().contains("transport.amqp.QueueName")) {
            params.put("transport.amqp.QueueName", svcName);
        }
        return params;
    }
}

