/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.phpivot;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.BadNodePlacementError;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.DefaultingExpressionVisitor;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExampleExpression;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderNode;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.flatten.ContentFlattenedTree;
import com.google.gxp.compiler.phpivot.EmptyPlaceholderError;
import com.google.gxp.compiler.phpivot.EphMissingPhError;
import com.google.gxp.compiler.phpivot.PhMissingEphError;
import com.google.gxp.compiler.phpivot.PlaceholderPivotedTree;
import com.google.gxp.compiler.phpivot.PlaceholderRequiresExampleError;
import java.util.List;

public class PlaceholderPivoter
implements Function<ContentFlattenedTree, PlaceholderPivotedTree> {
    private static final GetExampleVisitor GET_EXAMPLE_VISITOR = new GetExampleVisitor();

    @Override
    public PlaceholderPivotedTree apply(ContentFlattenedTree tree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(tree.getAlerts());
        Worker worker = new Worker(alertSetBuilder);
        Root root = tree.getRoot().acceptVisitor(worker.defaultVisitor);
        return new PlaceholderPivotedTree(tree.getSourcePosition(), alertSetBuilder.buildAndClear(), root);
    }

    private static class GetExampleVisitor
    extends DefaultingExpressionVisitor<String> {
        private GetExampleVisitor() {
        }

        @Override
        public String defaultVisitExpression(Expression value) {
            if (value.hasStaticString()) {
                return value.getStaticString(null, null);
            }
            return null;
        }

        @Override
        public String visitEscapeExpression(EscapeExpression expr) {
            return expr.getSubexpression().acceptVisitor(this);
        }

        @Override
        public String visitNativeExpression(NativeExpression expr) {
            return expr.getExample();
        }

        @Override
        public String visitNoMessage(NoMessage noMsg) {
            return noMsg.getSubexpression().acceptVisitor(this);
        }

        @Override
        public String visitConcatenation(Concatenation concat) {
            StringBuilder sb = new StringBuilder();
            for (Expression value : concat.getValues()) {
                String subString = value.acceptVisitor(this);
                if (subString == null) {
                    return null;
                }
                sb.append(subString);
            }
            return sb.toString();
        }

        @Override
        public String visitConditional(Conditional conditional) {
            Expression predicate;
            List<Conditional.Clause> clauses = conditional.getClauses();
            if (clauses.size() == 1 && (predicate = clauses.get(0).getPredicate()).alwaysEqualToXmlEnabled()) {
                return conditional.getElseExpression().acceptVisitor(this);
            }
            return null;
        }

        @Override
        public String visitExampleExpression(ExampleExpression value) {
            return value.getExample();
        }
    }

    private static class Worker {
        private final AlertSink alertSink;
        private final ExhaustiveExpressionVisitor defaultVisitor = new ExhaustiveExpressionVisitor(){

            @Override
            public Expression visitConcatenation(Concatenation node) {
                ConcatenationVisitor concatVisitor = new ConcatenationVisitor(node);
                for (Expression subExpression : node.getValues()) {
                    subExpression.acceptVisitor(concatVisitor);
                }
                return node.withValues(concatVisitor.getValues());
            }

            @Override
            public Expression visitPlaceholderStart(PlaceholderStart node) {
                Worker.this.alertSink.add(new BadNodePlacementError(node, null));
                return new StringConstant(node, node.getSchema(), "");
            }

            @Override
            public Expression visitPlaceholderEnd(PlaceholderEnd node) {
                Worker.this.alertSink.add(new EphMissingPhError(node));
                return new StringConstant(node, node.getSchema(), "");
            }
        };

        Worker(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        private static String createExample(AlertSink alertSink, PlaceholderStart phStart, Expression content) {
            String result = content.acceptVisitor(GET_EXAMPLE_VISITOR);
            if (result == null) {
                alertSink.add(new PlaceholderRequiresExampleError(phStart));
                result = "<var>" + phStart.getName() + "</var>";
            }
            return result;
        }

        private class ConcatenationVisitor
        extends DefaultingExpressionVisitor<Void> {
            private final List<Expression> values = Lists.newArrayList();
            private final List<Expression> phChildren = Lists.newArrayList();
            private PlaceholderStart phStart;
            private List<Expression> destination = this.values;
            private final Concatenation concat;

            ConcatenationVisitor(Concatenation concat) {
                this.concat = Preconditions.checkNotNull(concat);
            }

            public List<Expression> getValues() {
                if (this.phStart != null) {
                    Worker.this.alertSink.add(new PhMissingEphError(this.phStart));
                }
                return ImmutableList.copyOf(this.values);
            }

            @Override
            protected Void defaultVisitExpression(Expression node) {
                this.destination.add(node.acceptVisitor(Worker.this.defaultVisitor));
                return null;
            }

            @Override
            public Void visitPlaceholderStart(PlaceholderStart node) {
                if (this.phStart == null) {
                    this.phStart = node;
                    this.phChildren.clear();
                    this.destination = this.phChildren;
                } else {
                    Worker.this.alertSink.add(new BadNodePlacementError(node, this.phStart));
                }
                return null;
            }

            @Override
            public Void visitPlaceholderEnd(PlaceholderEnd node) {
                if (this.phStart == null) {
                    Worker.this.alertSink.add(new EphMissingPhError(node));
                } else {
                    Expression content = Concatenation.create(this.phStart.getSourcePosition(), this.concat.getSchema(), this.phChildren);
                    if (content.alwaysEmpty()) {
                        Worker.this.alertSink.add(new EmptyPlaceholderError(this.phStart));
                    } else {
                        String example = this.phStart.getExample();
                        if (example == null) {
                            example = Worker.createExample(Worker.this.alertSink, this.phStart, content);
                        }
                        this.values.add(new PlaceholderNode(this.phStart, this.phStart.getName(), example, content));
                    }
                    this.phStart = null;
                    this.destination = this.values;
                    this.phChildren.clear();
                }
                return null;
            }

            @Override
            public Void visitConcatenation(Concatenation node) {
                throw new UnexpectedNodeException(node);
            }
        }
    }
}

