/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.configuration.CoreOptions;
import org.apache.http.client.config.RequestConfig;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.enums.ClusterState;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.common.enums.FlinkK8sRestExposedType;
import org.apache.streampark.common.enums.ResolveOrder;
import org.apache.streampark.common.util.HttpClientUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.common.util.YarnUtils;
import org.apache.streampark.console.base.util.CommonUtils;
import org.apache.streampark.console.base.util.JacksonUtils;
import org.apache.streampark.console.core.metrics.flink.Overview;
import org.apache.streampark.console.core.utils.YarnQueueLabelExpression;

@TableName(value="t_flink_cluster")
public class FlinkCluster
implements Serializable {
    @TableId(type=IdType.AUTO)
    private Long id;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String address;
    private String clusterId;
    private String clusterName;
    private Integer executionMode;
    private Long versionId;
    private String k8sNamespace;
    private String serviceAccount;
    private String description;
    private Long userId;
    private String flinkImage;
    private String options;
    private String yarnQueue;
    private Boolean k8sHadoopIntegration;
    private String dynamicProperties;
    private Integer k8sRestExposedType;
    private String k8sConf;
    private Integer resolveOrder;
    @TableField(updateStrategy=FieldStrategy.IGNORED)
    private String exception;
    private Integer clusterState;
    private Date createTime = new Date();

    @JsonIgnore
    public FlinkK8sRestExposedType getK8sRestExposedTypeEnum() {
        return FlinkK8sRestExposedType.of((Integer)this.k8sRestExposedType);
    }

    public ExecutionMode getExecutionModeEnum() {
        return ExecutionMode.of((Integer)this.executionMode);
    }

    public ClusterState getClusterStateEnum() {
        return ClusterState.of((Integer)this.clusterState);
    }

    @JsonIgnore
    public Map<String, Object> getOptionMap() {
        if (StringUtils.isBlank((CharSequence)this.options)) {
            return Collections.emptyMap();
        }
        Map map = JacksonUtils.read(this.options, Map.class);
        if (ExecutionMode.YARN_SESSION.equals((Object)this.getExecutionModeEnum())) {
            map.put(ConfigConst.KEY_YARN_APP_NAME(), this.clusterName);
            map.putAll(YarnQueueLabelExpression.getQueueLabelMap(this.yarnQueue));
        }
        map.entrySet().removeIf(entry -> entry.getValue() == null);
        return map;
    }

    @JsonIgnore
    public URI getRemoteURI() {
        try {
            HttpClientUtils.httpGetRequest((String)this.address, (RequestConfig)RequestConfig.custom().setSocketTimeout(2000).build());
            return new URI(this.address);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean verifyClusterConnection() {
        if (ExecutionMode.REMOTE.equals((Object)this.getExecutionModeEnum())) {
            if (this.address == null) {
                return false;
            }
            if (!CommonUtils.isLegalUrl(this.address)) {
                return false;
            }
            try {
                String restUrl = this.address + "/overview";
                String result = HttpClientUtils.httpGetRequest((String)restUrl, (RequestConfig)RequestConfig.custom().setConnectTimeout(2000).build());
                JacksonUtils.read(result, Overview.class);
                return true;
            }
            catch (Exception restUrl) {
                return false;
            }
        }
        if (ExecutionMode.YARN_SESSION.equals((Object)this.getExecutionModeEnum())) {
            try {
                String restUrl = YarnUtils.getRMWebAppURL((boolean)true) + "/proxy/" + this.clusterId + "/overview";
                String result = HttpClientUtils.httpGetRequest((String)restUrl, (RequestConfig)RequestConfig.custom().setConnectTimeout(2000).build());
                JacksonUtils.read(result, Overview.class);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @JsonIgnore
    public Map<String, String> getFlinkConfig() throws JsonProcessingException {
        String restUrl = this.address + "/jobmanager/config";
        String json = HttpClientUtils.httpGetRequest((String)restUrl, (RequestConfig)RequestConfig.custom().setConnectTimeout(2000).build());
        if (StringUtils.isEmpty((CharSequence)json)) {
            return Collections.emptyMap();
        }
        List<Map<String, String>> confList = JacksonUtils.read(json, new TypeReference<List<Map<String, String>>>(){});
        HashMap<String, String> config = new HashMap<String, String>(0);
        confList.forEach(k -> {
            String cfr_ignored_0 = (String)config.put((String)k.get("key"), (String)k.get("value"));
        });
        return config;
    }

    @JsonIgnore
    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap dynamicProperties = PropertiesUtils.extractDynamicPropertiesAsJava((String)this.getDynamicProperties());
        map.putAll(this.getOptionMap());
        map.putAll(dynamicProperties);
        ResolveOrder resolveOrder = ResolveOrder.of((Integer)this.getResolveOrder());
        if (resolveOrder != null) {
            map.put(CoreOptions.CLASSLOADER_RESOLVE_ORDER.key(), resolveOrder.getName());
        }
        return map;
    }

    public Long getId() {
        return this.id;
    }

    public String getAddress() {
        return this.address;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Integer getExecutionMode() {
        return this.executionMode;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public String getK8sNamespace() {
        return this.k8sNamespace;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getFlinkImage() {
        return this.flinkImage;
    }

    public String getOptions() {
        return this.options;
    }

    public String getYarnQueue() {
        return this.yarnQueue;
    }

    public Boolean getK8sHadoopIntegration() {
        return this.k8sHadoopIntegration;
    }

    public String getDynamicProperties() {
        return this.dynamicProperties;
    }

    public Integer getK8sRestExposedType() {
        return this.k8sRestExposedType;
    }

    public String getK8sConf() {
        return this.k8sConf;
    }

    public Integer getResolveOrder() {
        return this.resolveOrder;
    }

    public String getException() {
        return this.exception;
    }

    public Integer getClusterState() {
        return this.clusterState;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setExecutionMode(Integer executionMode) {
        this.executionMode = executionMode;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public void setK8sNamespace(String k8sNamespace) {
        this.k8sNamespace = k8sNamespace;
    }

    public void setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setFlinkImage(String flinkImage) {
        this.flinkImage = flinkImage;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setYarnQueue(String yarnQueue) {
        this.yarnQueue = yarnQueue;
    }

    public void setK8sHadoopIntegration(Boolean k8sHadoopIntegration) {
        this.k8sHadoopIntegration = k8sHadoopIntegration;
    }

    public void setDynamicProperties(String dynamicProperties) {
        this.dynamicProperties = dynamicProperties;
    }

    public void setK8sRestExposedType(Integer k8sRestExposedType) {
        this.k8sRestExposedType = k8sRestExposedType;
    }

    public void setK8sConf(String k8sConf) {
        this.k8sConf = k8sConf;
    }

    public void setResolveOrder(Integer resolveOrder) {
        this.resolveOrder = resolveOrder;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public void setClusterState(Integer clusterState) {
        this.clusterState = clusterState;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkCluster)) {
            return false;
        }
        FlinkCluster other = (FlinkCluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$executionMode = this.getExecutionMode();
        Integer other$executionMode = other.getExecutionMode();
        if (this$executionMode == null ? other$executionMode != null : !((Object)this$executionMode).equals(other$executionMode)) {
            return false;
        }
        Long this$versionId = this.getVersionId();
        Long other$versionId = other.getVersionId();
        if (this$versionId == null ? other$versionId != null : !((Object)this$versionId).equals(other$versionId)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$k8sHadoopIntegration = this.getK8sHadoopIntegration();
        Boolean other$k8sHadoopIntegration = other.getK8sHadoopIntegration();
        if (this$k8sHadoopIntegration == null ? other$k8sHadoopIntegration != null : !((Object)this$k8sHadoopIntegration).equals(other$k8sHadoopIntegration)) {
            return false;
        }
        Integer this$k8sRestExposedType = this.getK8sRestExposedType();
        Integer other$k8sRestExposedType = other.getK8sRestExposedType();
        if (this$k8sRestExposedType == null ? other$k8sRestExposedType != null : !((Object)this$k8sRestExposedType).equals(other$k8sRestExposedType)) {
            return false;
        }
        Integer this$resolveOrder = this.getResolveOrder();
        Integer other$resolveOrder = other.getResolveOrder();
        if (this$resolveOrder == null ? other$resolveOrder != null : !((Object)this$resolveOrder).equals(other$resolveOrder)) {
            return false;
        }
        Integer this$clusterState = this.getClusterState();
        Integer other$clusterState = other.getClusterState();
        if (this$clusterState == null ? other$clusterState != null : !((Object)this$clusterState).equals(other$clusterState)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$clusterId = this.getClusterId();
        String other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !this$clusterId.equals(other$clusterId)) {
            return false;
        }
        String this$clusterName = this.getClusterName();
        String other$clusterName = other.getClusterName();
        if (this$clusterName == null ? other$clusterName != null : !this$clusterName.equals(other$clusterName)) {
            return false;
        }
        String this$k8sNamespace = this.getK8sNamespace();
        String other$k8sNamespace = other.getK8sNamespace();
        if (this$k8sNamespace == null ? other$k8sNamespace != null : !this$k8sNamespace.equals(other$k8sNamespace)) {
            return false;
        }
        String this$serviceAccount = this.getServiceAccount();
        String other$serviceAccount = other.getServiceAccount();
        if (this$serviceAccount == null ? other$serviceAccount != null : !this$serviceAccount.equals(other$serviceAccount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$flinkImage = this.getFlinkImage();
        String other$flinkImage = other.getFlinkImage();
        if (this$flinkImage == null ? other$flinkImage != null : !this$flinkImage.equals(other$flinkImage)) {
            return false;
        }
        String this$options = this.getOptions();
        String other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        String this$yarnQueue = this.getYarnQueue();
        String other$yarnQueue = other.getYarnQueue();
        if (this$yarnQueue == null ? other$yarnQueue != null : !this$yarnQueue.equals(other$yarnQueue)) {
            return false;
        }
        String this$dynamicProperties = this.getDynamicProperties();
        String other$dynamicProperties = other.getDynamicProperties();
        if (this$dynamicProperties == null ? other$dynamicProperties != null : !this$dynamicProperties.equals(other$dynamicProperties)) {
            return false;
        }
        String this$k8sConf = this.getK8sConf();
        String other$k8sConf = other.getK8sConf();
        if (this$k8sConf == null ? other$k8sConf != null : !this$k8sConf.equals(other$k8sConf)) {
            return false;
        }
        String this$exception = this.getException();
        String other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !this$exception.equals(other$exception)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkCluster;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $executionMode = this.getExecutionMode();
        result = result * 59 + ($executionMode == null ? 43 : ((Object)$executionMode).hashCode());
        Long $versionId = this.getVersionId();
        result = result * 59 + ($versionId == null ? 43 : ((Object)$versionId).hashCode());
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $k8sHadoopIntegration = this.getK8sHadoopIntegration();
        result = result * 59 + ($k8sHadoopIntegration == null ? 43 : ((Object)$k8sHadoopIntegration).hashCode());
        Integer $k8sRestExposedType = this.getK8sRestExposedType();
        result = result * 59 + ($k8sRestExposedType == null ? 43 : ((Object)$k8sRestExposedType).hashCode());
        Integer $resolveOrder = this.getResolveOrder();
        result = result * 59 + ($resolveOrder == null ? 43 : ((Object)$resolveOrder).hashCode());
        Integer $clusterState = this.getClusterState();
        result = result * 59 + ($clusterState == null ? 43 : ((Object)$clusterState).hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : $clusterId.hashCode());
        String $clusterName = this.getClusterName();
        result = result * 59 + ($clusterName == null ? 43 : $clusterName.hashCode());
        String $k8sNamespace = this.getK8sNamespace();
        result = result * 59 + ($k8sNamespace == null ? 43 : $k8sNamespace.hashCode());
        String $serviceAccount = this.getServiceAccount();
        result = result * 59 + ($serviceAccount == null ? 43 : $serviceAccount.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $flinkImage = this.getFlinkImage();
        result = result * 59 + ($flinkImage == null ? 43 : $flinkImage.hashCode());
        String $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        String $yarnQueue = this.getYarnQueue();
        result = result * 59 + ($yarnQueue == null ? 43 : $yarnQueue.hashCode());
        String $dynamicProperties = this.getDynamicProperties();
        result = result * 59 + ($dynamicProperties == null ? 43 : $dynamicProperties.hashCode());
        String $k8sConf = this.getK8sConf();
        result = result * 59 + ($k8sConf == null ? 43 : $k8sConf.hashCode());
        String $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkCluster(id=" + this.getId() + ", address=" + this.getAddress() + ", clusterId=" + this.getClusterId() + ", clusterName=" + this.getClusterName() + ", executionMode=" + this.getExecutionMode() + ", versionId=" + this.getVersionId() + ", k8sNamespace=" + this.getK8sNamespace() + ", serviceAccount=" + this.getServiceAccount() + ", description=" + this.getDescription() + ", userId=" + this.getUserId() + ", flinkImage=" + this.getFlinkImage() + ", options=" + this.getOptions() + ", yarnQueue=" + this.getYarnQueue() + ", k8sHadoopIntegration=" + this.getK8sHadoopIntegration() + ", dynamicProperties=" + this.getDynamicProperties() + ", k8sRestExposedType=" + this.getK8sRestExposedType() + ", k8sConf=" + this.getK8sConf() + ", resolveOrder=" + this.getResolveOrder() + ", exception=" + this.getException() + ", clusterState=" + this.getClusterState() + ", createTime=" + this.getCreateTime() + ")";
    }
}

