/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.SystemErasureCodingPolicies;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.SharedCacheConfig;
import org.apache.hadoop.mapreduce.filecache.ClientDistributedCacheManager;
import org.apache.hadoop.mapreduce.filecache.DistributedCache;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.client.api.SharedCacheClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class JobResourceUploader {
    protected static final Logger LOG = LoggerFactory.getLogger(JobResourceUploader.class);
    private static final String ROOT_PATH = "/";
    private final boolean useWildcard;
    private final FileSystem jtFs;
    private SharedCacheClient scClient = null;
    private SharedCacheConfig scConfig = new SharedCacheConfig();
    private ApplicationId appId = null;
    @VisibleForTesting
    protected static final String MAX_RESOURCE_ERR_MSG = "This job has exceeded the maximum number of submitted resources";
    @VisibleForTesting
    protected static final String MAX_TOTAL_RESOURCE_MB_ERR_MSG = "This job has exceeded the maximum size of submitted resources";
    @VisibleForTesting
    protected static final String MAX_SINGLE_RESOURCE_MB_ERR_MSG = "This job has exceeded the maximum size of a single submitted resource";

    JobResourceUploader(FileSystem submitFs, boolean useWildcard) {
        this.jtFs = submitFs;
        this.useWildcard = useWildcard;
    }

    private void initSharedCache(JobID jobid, Configuration conf) {
        this.scConfig.init(conf);
        if (this.scConfig.isSharedCacheEnabled()) {
            this.scClient = this.createSharedCacheClient(conf);
            this.appId = this.jobIDToAppId(jobid);
        }
    }

    private ApplicationId jobIDToAppId(JobID jobId) {
        return ApplicationId.newInstance(Long.parseLong(jobId.getJtIdentifier()), jobId.getId());
    }

    private void stopSharedCache() {
        if (this.scClient != null) {
            this.scClient.stop();
            this.scClient = null;
        }
    }

    @VisibleForTesting
    protected SharedCacheClient createSharedCacheClient(Configuration conf) {
        SharedCacheClient scc = SharedCacheClient.createSharedCacheClient();
        scc.init(conf);
        scc.start();
        return scc;
    }

    public void uploadResources(Job job, Path submitJobDir) throws IOException {
        try {
            this.initSharedCache(job.getJobID(), job.getConfiguration());
            this.uploadResourcesInternal(job, submitJobDir);
        }
        finally {
            this.stopSharedCache();
        }
    }

    private void uploadResourcesInternal(Job job, Path submitJobDir) throws IOException {
        Configuration conf = job.getConfiguration();
        short replication = (short)conf.getInt("mapreduce.client.submit.file.replication", 10);
        if (!conf.getBoolean("mapreduce.client.genericoptionsparser.used", false)) {
            LOG.warn("Hadoop command-line option parsing not performed. Implement the Tool interface and execute your application with ToolRunner to remedy this.");
        }
        LOG.debug("default FileSystem: " + this.jtFs.getUri());
        if (this.jtFs.exists(submitJobDir)) {
            throw new IOException("Not submitting job. Job directory " + submitJobDir + " already exists!! This is unexpected.Please check what's there in that directory");
        }
        submitJobDir = this.jtFs.makeQualified(submitJobDir);
        submitJobDir = new Path(submitJobDir.toUri().getPath());
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        this.mkdirs(this.jtFs, submitJobDir, mapredSysPerms);
        if (!conf.getBoolean("yarn.app.mapreduce.am.staging-dir.erasurecoding.enabled", false)) {
            this.disableErasureCodingForPath(submitJobDir);
        }
        Collection<String> files = conf.getStringCollection("tmpfiles");
        Collection<String> libjars = conf.getStringCollection("tmpjars");
        Collection<String> archives = conf.getStringCollection("tmparchives");
        String jobJar = job.getJar();
        files.addAll(conf.getStringCollection("mapreduce.job.cache.sharedcache.files"));
        libjars.addAll(conf.getStringCollection("mapreduce.job.cache.sharedcache.files.addtoclasspath"));
        archives.addAll(conf.getStringCollection("mapreduce.job.cache.sharedcache.archives"));
        HashMap<URI, FileStatus> statCache = new HashMap<URI, FileStatus>();
        this.checkLocalizationLimits(conf, files, libjars, archives, jobJar, statCache);
        LinkedHashMap<String, Boolean> fileSCUploadPolicies = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> archiveSCUploadPolicies = new LinkedHashMap<String, Boolean>();
        this.uploadFiles(job, files, submitJobDir, mapredSysPerms, replication, fileSCUploadPolicies, statCache);
        this.uploadLibJars(job, libjars, submitJobDir, mapredSysPerms, replication, fileSCUploadPolicies, statCache);
        this.uploadArchives(job, archives, submitJobDir, mapredSysPerms, replication, archiveSCUploadPolicies, statCache);
        this.uploadJobJar(job, jobJar, submitJobDir, replication, statCache);
        this.addLog4jToDistributedCache(job, submitJobDir);
        Job.setFileSharedCacheUploadPolicies(conf, fileSCUploadPolicies);
        Job.setArchiveSharedCacheUploadPolicies(conf, archiveSCUploadPolicies);
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities(conf, statCache);
        ClientDistributedCacheManager.getDelegationTokens(conf, job.getCredentials());
    }

    @VisibleForTesting
    void uploadFiles(Job job, Collection<String> files, Path submitJobDir, FsPermission mapredSysPerms, short submitReplication, Map<String, Boolean> fileSCUploadPolicies, Map<URI, FileStatus> statCache) throws IOException {
        Configuration conf = job.getConfiguration();
        Path filesDir = JobSubmissionFiles.getJobDistCacheFiles(submitJobDir);
        if (!files.isEmpty()) {
            this.mkdirs(this.jtFs, filesDir, mapredSysPerms);
            for (String tmpFile : files) {
                URI tmpURI = null;
                try {
                    tmpURI = new URI(tmpFile);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Error parsing files argument. Argument must be a valid URI: " + tmpFile, e);
                }
                Path tmp = new Path(tmpURI);
                URI newURI = null;
                boolean uploadToSharedCache = false;
                if (this.scConfig.isSharedCacheFilesEnabled() && (newURI = this.useSharedCache(tmpURI, tmp.getName(), statCache, conf, true)) == null) {
                    uploadToSharedCache = true;
                }
                if (newURI == null) {
                    Path newPath = this.copyRemoteFiles(filesDir, tmp, conf, submitReplication);
                    try {
                        newURI = this.getPathURI(newPath, tmpURI.getFragment());
                    }
                    catch (URISyntaxException ue) {
                        throw new IOException("Failed to create a URI (URISyntaxException) for the remote path " + newPath + ". This was based on the files parameter: " + tmpFile, ue);
                    }
                }
                job.addCacheFile(newURI);
                if (!this.scConfig.isSharedCacheFilesEnabled()) continue;
                fileSCUploadPolicies.put(newURI.toString(), uploadToSharedCache);
            }
        }
    }

    @VisibleForTesting
    void uploadLibJars(Job job, Collection<String> libjars, Path submitJobDir, FsPermission mapredSysPerms, short submitReplication, Map<String, Boolean> fileSCUploadPolicies, Map<URI, FileStatus> statCache) throws IOException {
        Configuration conf = job.getConfiguration();
        Path libjarsDir = JobSubmissionFiles.getJobDistCacheLibjars(submitJobDir);
        if (!libjars.isEmpty()) {
            this.mkdirs(this.jtFs, libjarsDir, mapredSysPerms);
            LinkedList<URI> libjarURIs = new LinkedList<URI>();
            boolean foundFragment = false;
            for (String tmpjars : libjars) {
                URI tmpURI = null;
                try {
                    tmpURI = new URI(tmpjars);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Error parsing libjars argument. Argument must be a valid URI: " + tmpjars, e);
                }
                Path tmp = new Path(tmpURI);
                URI newURI = null;
                boolean uploadToSharedCache = false;
                boolean fromSharedCache = false;
                if (this.scConfig.isSharedCacheLibjarsEnabled()) {
                    newURI = this.useSharedCache(tmpURI, tmp.getName(), statCache, conf, true);
                    if (newURI == null) {
                        uploadToSharedCache = true;
                    } else {
                        fromSharedCache = true;
                    }
                }
                if (newURI == null) {
                    Path newPath = this.copyRemoteFiles(libjarsDir, tmp, conf, submitReplication);
                    try {
                        newURI = this.getPathURI(newPath, tmpURI.getFragment());
                    }
                    catch (URISyntaxException ue) {
                        throw new IOException("Failed to create a URI (URISyntaxException) for the remote path " + newPath + ". This was based on the libjar parameter: " + tmpjars, ue);
                    }
                }
                if (!foundFragment) {
                    foundFragment = newURI.getFragment() != null && !fromSharedCache;
                }
                DistributedCache.addFileToClassPath(new Path(newURI.getPath()), conf, this.jtFs, false);
                if (fromSharedCache) {
                    DistributedCache.addCacheFile(newURI, conf);
                } else {
                    libjarURIs.add(newURI);
                }
                if (!this.scConfig.isSharedCacheLibjarsEnabled()) continue;
                fileSCUploadPolicies.put(newURI.toString(), uploadToSharedCache);
            }
            if (this.useWildcard && !foundFragment) {
                Path libJarsDirWildcard = this.jtFs.makeQualified(new Path(libjarsDir, "*"));
                DistributedCache.addCacheFile(libJarsDirWildcard.toUri(), conf);
            } else {
                for (URI uri : libjarURIs) {
                    DistributedCache.addCacheFile(uri, conf);
                }
            }
        }
    }

    @VisibleForTesting
    void uploadArchives(Job job, Collection<String> archives, Path submitJobDir, FsPermission mapredSysPerms, short submitReplication, Map<String, Boolean> archiveSCUploadPolicies, Map<URI, FileStatus> statCache) throws IOException {
        Configuration conf = job.getConfiguration();
        Path archivesDir = JobSubmissionFiles.getJobDistCacheArchives(submitJobDir);
        if (!archives.isEmpty()) {
            this.mkdirs(this.jtFs, archivesDir, mapredSysPerms);
            for (String tmpArchives : archives) {
                URI tmpURI;
                try {
                    tmpURI = new URI(tmpArchives);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Error parsing archives argument. Argument must be a valid URI: " + tmpArchives, e);
                }
                Path tmp = new Path(tmpURI);
                URI newURI = null;
                boolean uploadToSharedCache = false;
                if (this.scConfig.isSharedCacheArchivesEnabled() && (newURI = this.useSharedCache(tmpURI, tmp.getName(), statCache, conf, true)) == null) {
                    uploadToSharedCache = true;
                }
                if (newURI == null) {
                    Path newPath = this.copyRemoteFiles(archivesDir, tmp, conf, submitReplication);
                    try {
                        newURI = this.getPathURI(newPath, tmpURI.getFragment());
                    }
                    catch (URISyntaxException ue) {
                        throw new IOException("Failed to create a URI (URISyntaxException) for the remote path " + newPath + ". This was based on the archive parameter: " + tmpArchives, ue);
                    }
                }
                job.addCacheArchive(newURI);
                if (!this.scConfig.isSharedCacheArchivesEnabled()) continue;
                archiveSCUploadPolicies.put(newURI.toString(), uploadToSharedCache);
            }
        }
    }

    @VisibleForTesting
    void uploadJobJar(Job job, String jobJar, Path submitJobDir, short submitReplication, Map<URI, FileStatus> statCache) throws IOException {
        Configuration conf = job.getConfiguration();
        if (jobJar != null) {
            if ("".equals(job.getJobName())) {
                job.setJobName(new Path(jobJar).getName());
            }
            Path jobJarPath = new Path(jobJar);
            URI jobJarURI = jobJarPath.toUri();
            Path newJarPath = null;
            boolean uploadToSharedCache = false;
            if (jobJarURI.getScheme() == null || jobJarURI.getScheme().equals("file")) {
                if (this.scConfig.isSharedCacheJobjarEnabled()) {
                    jobJarPath = FileSystem.getLocal(conf).makeQualified(jobJarPath);
                    URI newURI = this.useSharedCache(jobJarPath.toUri(), null, statCache, conf, false);
                    if (newURI == null) {
                        uploadToSharedCache = true;
                    } else {
                        newJarPath = this.stringToPath(newURI.toString());
                        conf.setBoolean("mapreduce.job.jobjar.visibility", true);
                    }
                }
                if (newJarPath == null) {
                    newJarPath = JobSubmissionFiles.getJobJar(submitJobDir);
                    this.copyJar(jobJarPath, newJarPath, submitReplication);
                }
            } else if (this.scConfig.isSharedCacheJobjarEnabled()) {
                URI newURI = this.useSharedCache(jobJarURI, null, statCache, conf, false);
                if (newURI == null) {
                    uploadToSharedCache = true;
                    newJarPath = jobJarPath;
                } else {
                    newJarPath = this.stringToPath(newURI.toString());
                    conf.setBoolean("mapreduce.job.jobjar.visibility", true);
                }
            } else {
                newJarPath = jobJarPath;
            }
            job.setJar(newJarPath.toString());
            if (this.scConfig.isSharedCacheJobjarEnabled()) {
                conf.setBoolean("mapreduce.job.jobjar.sharedcache.uploadpolicy", uploadToSharedCache);
            }
        } else {
            LOG.warn("No job jar file set.  User classes may not be found. See Job or Job#setJar(String).");
        }
    }

    @VisibleForTesting
    void checkLocalizationLimits(Configuration conf, Collection<String> files, Collection<String> libjars, Collection<String> archives, String jobJar, Map<URI, FileStatus> statCache) throws IOException {
        LimitChecker limitChecker = new LimitChecker(conf);
        if (!limitChecker.hasLimits()) {
            return;
        }
        Collection<String> dcFiles = conf.getStringCollection("mapreduce.job.cache.files");
        Collection<String> dcArchives = conf.getStringCollection("mapreduce.job.cache.archives");
        for (String uri : dcFiles) {
            this.explorePath(conf, this.stringToPath(uri), limitChecker, statCache);
        }
        for (String uri : dcArchives) {
            this.explorePath(conf, this.stringToPath(uri), limitChecker, statCache);
        }
        for (String uri : files) {
            this.explorePath(conf, this.stringToPath(uri), limitChecker, statCache);
        }
        for (String uri : libjars) {
            this.explorePath(conf, this.stringToPath(uri), limitChecker, statCache);
        }
        for (String uri : archives) {
            this.explorePath(conf, this.stringToPath(uri), limitChecker, statCache);
        }
        if (jobJar != null) {
            this.explorePath(conf, this.stringToPath(jobJar), limitChecker, statCache);
        }
    }

    @VisibleForTesting
    Path stringToPath(String s) {
        try {
            URI uri = new URI(s);
            return new Path(uri.getScheme(), uri.getAuthority(), uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error parsing argument. Argument must be a valid URI: " + s, e);
        }
    }

    private void explorePath(Configuration job, Path p, LimitChecker limitChecker, Map<URI, FileStatus> statCache) throws IOException {
        FileStatus status;
        Path pathWithScheme = p;
        if (!pathWithScheme.toUri().isAbsolute()) {
            LocalFileSystem localFs = FileSystem.getLocal(job);
            pathWithScheme = ((FileSystem)localFs).makeQualified(p);
        }
        if ((status = this.getFileStatus(statCache, job, pathWithScheme)).isDirectory()) {
            FileStatus[] statusArray;
            for (FileStatus s : statusArray = pathWithScheme.getFileSystem(job).listStatus(pathWithScheme)) {
                this.explorePath(job, s.getPath(), limitChecker, statCache);
            }
        } else {
            limitChecker.addFile(pathWithScheme, status.getLen());
        }
    }

    @VisibleForTesting
    FileStatus getFileStatus(Map<URI, FileStatus> statCache, Configuration job, Path p) throws IOException {
        URI u = p.toUri();
        FileStatus status = statCache.get(u);
        if (status == null) {
            status = p.getFileSystem(job).getFileStatus(p);
            statCache.put(u, status);
        }
        return status;
    }

    @VisibleForTesting
    boolean mkdirs(FileSystem fs, Path dir, FsPermission permission) throws IOException {
        return FileSystem.mkdirs(fs, dir, permission);
    }

    @VisibleForTesting
    Path copyRemoteFiles(Path parentDir, Path originalPath, Configuration conf, short replication) throws IOException {
        FileSystem remoteFs = null;
        remoteFs = originalPath.getFileSystem(conf);
        if (FileUtil.compareFs(remoteFs, this.jtFs)) {
            return originalPath;
        }
        boolean root = false;
        if (ROOT_PATH.equals(originalPath.toUri().getPath())) {
            root = true;
        } else {
            String uriString = originalPath.toUri().toString();
            if (uriString.endsWith(ROOT_PATH)) {
                try {
                    URI strippedURI = new URI(uriString.substring(0, uriString.length() - 1));
                    originalPath = new Path(strippedURI);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Error processing URI", e);
                }
            }
        }
        Path newPath = root ? parentDir : new Path(parentDir, originalPath.getName());
        FileUtil.copy(remoteFs, originalPath, this.jtFs, newPath, false, conf);
        this.jtFs.setReplication(newPath, replication);
        this.jtFs.makeQualified(newPath);
        return newPath;
    }

    private URI useSharedCache(URI sourceFile, String resourceName, Map<URI, FileStatus> statCache, Configuration conf, boolean honorFragment) throws IOException {
        if (this.scClient == null) {
            return null;
        }
        Path filePath = new Path(sourceFile);
        if (this.getFileStatus(statCache, conf, filePath).isDirectory()) {
            LOG.warn("Shared cache does not support directories (see YARN-6097). Will not upload " + filePath + " to the shared cache.");
            return null;
        }
        String rn = resourceName;
        if (honorFragment && sourceFile.getFragment() != null) {
            rn = sourceFile.getFragment();
        }
        String checksum = this.scClient.getFileChecksum(filePath);
        URL url = null;
        try {
            url = this.scClient.use(this.appId, checksum);
        }
        catch (YarnException e) {
            LOG.warn("Error trying to contact the shared cache manager, disabling the SCMClient for the rest of this job submission", (Throwable)e);
            this.stopSharedCache();
        }
        if (url != null) {
            URI uri = null;
            try {
                String name = new Path(url.getFile()).getName();
                uri = rn != null && !name.equals(rn) ? new URI(url.getScheme(), url.getUserInfo(), url.getHost(), url.getPort(), url.getFile(), null, rn) : new URI(url.getScheme(), url.getUserInfo(), url.getHost(), url.getPort(), url.getFile(), null, null);
                return uri;
            }
            catch (URISyntaxException e) {
                LOG.warn("Error trying to convert URL received from shared cache to a URI: " + url.toString());
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    void copyJar(Path originalJarPath, Path submitJarFile, short replication) throws IOException {
        this.jtFs.copyFromLocalFile(originalJarPath, submitJarFile);
        this.jtFs.setReplication(submitJarFile, replication);
        this.jtFs.setPermission(submitJarFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
    }

    private void addLog4jToDistributedCache(Job job, Path jobSubmitDir) throws IOException {
        Configuration conf = job.getConfiguration();
        String log4jPropertyFile = conf.get("mapreduce.job.log4j-properties-file", "");
        if (!log4jPropertyFile.isEmpty()) {
            short replication = (short)conf.getInt("mapreduce.client.submit.file.replication", 10);
            this.copyLog4jPropertyFile(job, jobSubmitDir, replication);
        }
    }

    private URI getPathURI(Path destPath, String fragment) throws URISyntaxException {
        URI pathURI = destPath.toUri();
        if (pathURI.getFragment() == null && fragment != null) {
            pathURI = new URI(pathURI.toString() + "#" + fragment);
        }
        return pathURI;
    }

    private void copyLog4jPropertyFile(Job job, Path submitJobDir, short replication) throws IOException {
        Configuration conf = job.getConfiguration();
        String file = this.validateFilePath(conf.get("mapreduce.job.log4j-properties-file"), conf);
        LOG.debug("default FileSystem: " + this.jtFs.getUri());
        FsPermission mapredSysPerms = new FsPermission(JobSubmissionFiles.JOB_DIR_PERMISSION);
        try {
            this.jtFs.getFileStatus(submitJobDir);
        }
        catch (FileNotFoundException e) {
            throw new IOException("Cannot find job submission directory! It should just be created, so something wrong here.", e);
        }
        Path fileDir = JobSubmissionFiles.getJobLog4jFile(submitJobDir);
        if (file != null) {
            FileSystem.mkdirs(this.jtFs, fileDir, mapredSysPerms);
            URI tmpURI = null;
            try {
                tmpURI = new URI(file);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            Path tmp = new Path(tmpURI);
            Path newPath = this.copyRemoteFiles(fileDir, tmp, conf, replication);
            DistributedCache.addFileToClassPath(new Path(newPath.toUri().getPath()), conf);
        }
    }

    private String validateFilePath(String file, Configuration conf) throws IOException {
        String finalPath;
        URI pathURI;
        if (file == null) {
            return null;
        }
        if (file.isEmpty()) {
            throw new IllegalArgumentException("File name can't be empty string");
        }
        try {
            pathURI = new URI(file);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        Path path = new Path(pathURI);
        if (pathURI.getScheme() == null) {
            LocalFileSystem localFs = FileSystem.getLocal(conf);
            ((FileSystem)localFs).getFileStatus(path);
            finalPath = path.makeQualified(((FileSystem)localFs).getUri(), ((FileSystem)localFs).getWorkingDirectory()).toString();
        } else {
            FileSystem fs = path.getFileSystem(conf);
            fs.getFileStatus(path);
            finalPath = path.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString();
        }
        return finalPath;
    }

    private void disableErasureCodingForPath(Path path) throws IOException {
        block4: {
            try {
                if (this.jtFs instanceof DistributedFileSystem) {
                    LOG.info("Disabling Erasure Coding for path: " + path);
                    DistributedFileSystem dfs = (DistributedFileSystem)this.jtFs;
                    dfs.setErasureCodingPolicy(path, SystemErasureCodingPolicies.getReplicationPolicy().getName());
                }
            }
            catch (RemoteException e) {
                if (!RpcNoSuchMethodException.class.getName().equals(e.getClassName())) {
                    throw e;
                }
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("Ignore disabling erasure coding for path {} because method disableErasureCodingForPath doesn't exist, probably talking to a lower version HDFS.", (Object)path.toString(), (Object)e);
            }
        }
    }

    private static class LimitChecker {
        private long totalSizeBytes = 0L;
        private int totalNumberOfResources = 0;
        private long currentMaxSizeOfFileBytes = 0L;
        private final long maxSizeMB;
        private final int maxNumOfResources;
        private final long maxSizeOfResourceMB;
        private final long totalConfigSizeBytes;
        private final long totalConfigSizeOfResourceBytes;

        LimitChecker(Configuration conf) {
            this.maxNumOfResources = conf.getInt("mapreduce.job.cache.limit.max-resources", 0);
            this.maxSizeMB = conf.getLong("mapreduce.job.cache.limit.max-resources-mb", 0L);
            this.maxSizeOfResourceMB = conf.getLong("mapreduce.job.cache.limit.max-single-resource-mb", 0L);
            this.totalConfigSizeBytes = this.maxSizeMB * 1024L * 1024L;
            this.totalConfigSizeOfResourceBytes = this.maxSizeOfResourceMB * 1024L * 1024L;
        }

        private boolean hasLimits() {
            return this.maxNumOfResources > 0 || this.maxSizeMB > 0L || this.maxSizeOfResourceMB > 0L;
        }

        private void addFile(Path p, long fileSizeBytes) throws IOException {
            ++this.totalNumberOfResources;
            this.totalSizeBytes += fileSizeBytes;
            if (fileSizeBytes > this.currentMaxSizeOfFileBytes) {
                this.currentMaxSizeOfFileBytes = fileSizeBytes;
            }
            if (this.totalConfigSizeBytes > 0L && this.totalSizeBytes > this.totalConfigSizeBytes) {
                throw new IOException("This job has exceeded the maximum size of submitted resources (Max: " + this.maxSizeMB + "MB).");
            }
            if (this.maxNumOfResources > 0 && this.totalNumberOfResources > this.maxNumOfResources) {
                throw new IOException("This job has exceeded the maximum number of submitted resources (Max: " + this.maxNumOfResources + ").");
            }
            if (this.totalConfigSizeOfResourceBytes > 0L && this.currentMaxSizeOfFileBytes > this.totalConfigSizeOfResourceBytes) {
                throw new IOException("This job has exceeded the maximum size of a single submitted resource (Max: " + this.maxSizeOfResourceMB + "MB, Violating resource: " + p + ").");
            }
        }
    }
}

