/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.AccessToken;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.mapper.AccessTokenMapper;
import org.apache.streampark.console.system.service.AccessTokenService;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class AccessTokenServiceImpl
extends ServiceImpl<AccessTokenMapper, AccessToken>
implements AccessTokenService {
    private static final Logger log = LoggerFactory.getLogger(AccessTokenServiceImpl.class);
    @Autowired
    private UserService userService;

    @Override
    public RestResponse generateToken(Long userId, String expireTime, String description) {
        User user = (User)this.userService.getById(userId);
        if (Objects.isNull(user)) {
            return RestResponse.success().put("code", (Object)0).message("user not available");
        }
        if (StringUtils.isEmpty((CharSequence)expireTime)) {
            expireTime = "9999-01-01 00:00:00";
        }
        Long ttl = DateUtils.getTime((String)expireTime, (String)DateUtils.fullFormat(), (TimeZone)TimeZone.getDefault());
        String token = WebUtils.encryptToken(JWTUtil.sign(user.getUserId(), user.getUsername(), ttl));
        JWTToken jwtToken = new JWTToken(token, expireTime);
        AccessToken accessToken = new AccessToken();
        accessToken.setToken(jwtToken.getToken());
        accessToken.setUserId(user.getUserId());
        accessToken.setDescription(description);
        accessToken.setExpireTime(DateUtils.stringToDate((String)jwtToken.getExpireAt()));
        accessToken.setCreateTime(new Date());
        accessToken.setStatus(AccessToken.STATUS_ENABLE);
        this.save(accessToken);
        return RestResponse.success().data(accessToken);
    }

    @Override
    public boolean deleteToken(Long id) {
        return this.removeById(id);
    }

    @Override
    public IPage<AccessToken> findAccessTokens(AccessToken tokenParam, RestRequest request) {
        Page page = new MybatisPager().getDefaultPage(request);
        ((AccessTokenMapper)this.baseMapper).page(page, tokenParam);
        List records = page.getRecords();
        page.setRecords(records);
        return page;
    }

    @Override
    public boolean checkTokenEffective(Long userId, String token) {
        AccessToken res = ((AccessTokenMapper)this.baseMapper).getByUserToken(userId, token);
        return res != null && AccessToken.STATUS_ENABLE.equals(res.getFinalStatus());
    }

    @Override
    public RestResponse toggleToken(Long tokenId) {
        AccessToken tokenInfo = ((AccessTokenMapper)this.baseMapper).getById(tokenId);
        if (Objects.isNull(tokenInfo)) {
            return RestResponse.fail("accessToken could not be found!", ResponseCode.CODE_FAIL_ALERT);
        }
        if ("0".equals(tokenInfo.getUserStatus())) {
            return RestResponse.fail("user status is locked, could not operate this accessToken!", ResponseCode.CODE_FAIL_ALERT);
        }
        Integer status = tokenInfo.getStatus().equals(AccessToken.STATUS_ENABLE) ? AccessToken.STATUS_DISABLE : AccessToken.STATUS_ENABLE;
        AccessToken updateObj = new AccessToken();
        updateObj.setStatus(status);
        updateObj.setId(tokenId);
        return RestResponse.success(this.updateById(updateObj));
    }

    @Override
    public AccessToken getByUserId(Long userId) {
        return ((AccessTokenMapper)this.baseMapper).getByUserId(userId);
    }
}

