/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.data.schema.HCatSchema;
import org.apache.hive.hcatalog.mapreduce.PartInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HCatSplit
extends InputSplit
implements Writable,
org.apache.hadoop.mapred.InputSplit {
    private static final Logger LOG = LoggerFactory.getLogger(HCatSplit.class);
    private PartInfo partitionInfo;
    private org.apache.hadoop.mapred.InputSplit baseMapRedSplit;
    private HCatSchema tableSchema;
    private HiveConf hiveConf;

    public HCatSplit() {
    }

    public HCatSplit(PartInfo partitionInfo, org.apache.hadoop.mapred.InputSplit baseMapRedSplit, HCatSchema tableSchema) {
        this.partitionInfo = partitionInfo;
        this.baseMapRedSplit = baseMapRedSplit;
        this.tableSchema = tableSchema;
    }

    public PartInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public org.apache.hadoop.mapred.InputSplit getBaseSplit() {
        return this.baseMapRedSplit;
    }

    public HCatSchema getDataSchema() {
        return this.partitionInfo.getPartitionSchema();
    }

    public HCatSchema getTableSchema() {
        return this.tableSchema;
    }

    public long getLength() {
        try {
            return this.baseMapRedSplit.getLength();
        }
        catch (IOException e) {
            LOG.warn("Exception in HCatSplit", (Throwable)e);
            return 0L;
        }
    }

    public String[] getLocations() {
        try {
            return this.baseMapRedSplit.getLocations();
        }
        catch (IOException e) {
            LOG.warn("Exception in HCatSplit", (Throwable)e);
            return new String[0];
        }
    }

    public void readFields(DataInput input) throws IOException {
        String partitionInfoString = WritableUtils.readString((DataInput)input);
        this.partitionInfo = (PartInfo)HCatUtil.deserialize(partitionInfoString);
        String baseSplitClassName = WritableUtils.readString((DataInput)input);
        try {
            Class<?> splitClass = Class.forName(baseSplitClassName);
            Constructor<?> constructor = splitClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            org.apache.hadoop.mapred.InputSplit split = (org.apache.hadoop.mapred.InputSplit)constructor.newInstance(new Object[0]);
            split.readFields(input);
            this.baseMapRedSplit = split;
        }
        catch (Exception e) {
            throw new IOException("Exception from " + baseSplitClassName, e);
        }
        String tableSchemaString = WritableUtils.readString((DataInput)input);
        this.tableSchema = (HCatSchema)HCatUtil.deserialize(tableSchemaString);
    }

    public void write(DataOutput output) throws IOException {
        String partitionInfoString = HCatUtil.serialize(this.partitionInfo);
        WritableUtils.writeString((DataOutput)output, (String)partitionInfoString);
        WritableUtils.writeString((DataOutput)output, (String)this.baseMapRedSplit.getClass().getName());
        org.apache.hadoop.mapred.InputSplit baseSplitWritable = this.baseMapRedSplit;
        baseSplitWritable.write(output);
        String tableSchemaString = HCatUtil.serialize(this.tableSchema);
        WritableUtils.writeString((DataOutput)output, (String)tableSchemaString);
    }
}

