/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.impl;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class QuotableStringUtil {
    private static final Pattern REQUIRES_NO_QUOTES = Pattern.compile("[a-zA-Z0-9-_\\./:*@]+");

    private QuotableStringUtil() {
    }

    @NotNull
    public static final String forRepoInitString(@NotNull String string) {
        return REQUIRES_NO_QUOTES.matcher(string).matches() ? string : "\"" + string + "\"";
    }

    @NotNull
    public static final List<String> forRepoInitString(@NotNull List<String> strings) {
        return strings.stream().map(QuotableStringUtil::forRepoInitString).collect(Collectors.toList());
    }
}

