/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.restapi;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.skywalking.generator.Generator;
import org.apache.skywalking.restapi.SegmentGenerator;

@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public final class SegmentRequest
implements Generator<Object, List<SegmentGenerator.SegmentResult>> {
    private Generator<String, String> traceId;
    private Generator<String, String> serviceName;
    private Generator<String, String> serviceInstanceName;
    private Generator<Object, List<SegmentGenerator>> segments;
    private List<String> serviceList;

    void init(String group) {
        String prefix = this.getServiceName().next("");
        List<SegmentGenerator> segments = this.getSegments().next("");
        this.serviceList = IntStream.range(0, segments.size()).mapToObj(i -> {
            if (Strings.isNullOrEmpty((String)group)) {
                return prefix + i;
            }
            return group + "::" + prefix + i;
        }).collect(Collectors.toList());
    }

    @Override
    public List<SegmentGenerator.SegmentResult> next(Object ignored) {
        String traceId = this.getTraceId().next(null);
        List<SegmentGenerator> segments = this.getSegments().next(traceId);
        SegmentGenerator.SegmentResult last = null;
        List context = IntStream.range(0, segments.size()).mapToObj(i -> new SegmentGenerator.SegmentContext(traceId, this.serviceList.get(i), this.getServiceInstanceName().next(this.serviceList.get(i)))).collect(Collectors.toList());
        ArrayList<SegmentGenerator.SegmentResult> result = new ArrayList<SegmentGenerator.SegmentResult>(segments.size());
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            SegmentGenerator.SegmentContext ctx = (SegmentGenerator.SegmentContext)context.get(i2);
            ctx.parentSegment = last;
            if (i2 < segments.size() - 1) {
                ctx.peer = ((SegmentGenerator.SegmentContext)context.get((int)(i2 + 1))).serviceInstanceName;
            }
            last = segments.get(i2).next(ctx);
            result.add(last);
        }
        return result;
    }

    @Generated
    public SegmentRequest() {
    }

    @Generated
    public Generator<String, String> getTraceId() {
        return this.traceId;
    }

    @Generated
    public Generator<String, String> getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Generator<String, String> getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    @Generated
    public Generator<Object, List<SegmentGenerator>> getSegments() {
        return this.segments;
    }

    @Generated
    public List<String> getServiceList() {
        return this.serviceList;
    }

    @Generated
    public void setTraceId(Generator<String, String> traceId) {
        this.traceId = traceId;
    }

    @Generated
    public void setServiceName(Generator<String, String> serviceName) {
        this.serviceName = serviceName;
    }

    @Generated
    public void setServiceInstanceName(Generator<String, String> serviceInstanceName) {
        this.serviceInstanceName = serviceInstanceName;
    }

    @Generated
    public void setSegments(Generator<Object, List<SegmentGenerator>> segments) {
        this.segments = segments;
    }

    @Generated
    public void setServiceList(List<String> serviceList) {
        this.serviceList = serviceList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentRequest)) {
            return false;
        }
        SegmentRequest other = (SegmentRequest)o;
        Generator<String, String> this$traceId = this.getTraceId();
        Generator<String, String> other$traceId = other.getTraceId();
        if (this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId)) {
            return false;
        }
        Generator<String, String> this$serviceName = this.getServiceName();
        Generator<String, String> other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        Generator<String, String> this$serviceInstanceName = this.getServiceInstanceName();
        Generator<String, String> other$serviceInstanceName = other.getServiceInstanceName();
        if (this$serviceInstanceName == null ? other$serviceInstanceName != null : !this$serviceInstanceName.equals(other$serviceInstanceName)) {
            return false;
        }
        Generator<Object, List<SegmentGenerator>> this$segments = this.getSegments();
        Generator<Object, List<SegmentGenerator>> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !this$segments.equals(other$segments)) {
            return false;
        }
        List<String> this$serviceList = this.getServiceList();
        List<String> other$serviceList = other.getServiceList();
        return !(this$serviceList == null ? other$serviceList != null : !((Object)this$serviceList).equals(other$serviceList));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Generator<String, String> $traceId = this.getTraceId();
        result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
        Generator<String, String> $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        Generator<String, String> $serviceInstanceName = this.getServiceInstanceName();
        result = result * 59 + ($serviceInstanceName == null ? 43 : $serviceInstanceName.hashCode());
        Generator<Object, List<SegmentGenerator>> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : $segments.hashCode());
        List<String> $serviceList = this.getServiceList();
        result = result * 59 + ($serviceList == null ? 43 : ((Object)$serviceList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SegmentRequest(traceId=" + this.getTraceId() + ", serviceName=" + this.getServiceName() + ", serviceInstanceName=" + this.getServiceInstanceName() + ", segments=" + this.getSegments() + ", serviceList=" + this.getServiceList() + ")";
    }
}

