/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.exporter.provider.kafka.log;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import lombok.Generated;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.logging.v3.JSONLog;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.logging.v3.LogTags;
import org.apache.skywalking.apm.network.logging.v3.TextLog;
import org.apache.skywalking.apm.network.logging.v3.TraceContext;
import org.apache.skywalking.apm.network.logging.v3.YAMLLog;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.manual.log.LogRecord;
import org.apache.skywalking.oap.server.core.exporter.LogExportService;
import org.apache.skywalking.oap.server.core.query.type.ContentType;
import org.apache.skywalking.oap.server.exporter.provider.ExporterSetting;
import org.apache.skywalking.oap.server.exporter.provider.kafka.KafkaExportProducer;
import org.apache.skywalking.oap.server.library.datacarrier.DataCarrier;
import org.apache.skywalking.oap.server.library.datacarrier.buffer.BufferStrategy;
import org.apache.skywalking.oap.server.library.datacarrier.consumer.IConsumer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaLogExporter
extends KafkaExportProducer
implements LogExportService,
IConsumer<LogRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaLogExporter.class);
    private DataCarrier<LogRecord> exportBuffer;
    private CounterMetrics successCounter;
    private CounterMetrics errorCounter;
    private final ModuleManager moduleManager;

    public KafkaLogExporter(ModuleManager manager, ExporterSetting setting) {
        super(setting);
        this.moduleManager = manager;
    }

    public void start() {
        super.getProducer();
        this.exportBuffer = new DataCarrier("KafkaLogExporter", "KafkaLogExporter", this.setting.getBufferChannelNum(), this.setting.getBufferChannelSize(), BufferStrategy.IF_POSSIBLE);
        this.exportBuffer.consume((IConsumer)this, 1, 200L);
        MetricsCreator metricsCreator = (MetricsCreator)this.moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.successCounter = metricsCreator.createCounter("kafka_exporter_log_success_count", "The success number of log exported by kafka exporter.", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
        this.errorCounter = metricsCreator.createCounter("kafka_exporter_log_error_count", "The error number of log exported by kafka exporter", new MetricsTag.Keys(new String[]{"protocol"}), new MetricsTag.Values(new String[]{"kafka"}));
    }

    public void export(LogRecord logRecord) {
        if (logRecord != null) {
            this.exportBuffer.produce((Object)logRecord);
        }
    }

    public boolean isEnabled() {
        return this.setting.isEnableKafkaLog();
    }

    public void consume(List<LogRecord> data) {
        for (LogRecord logRecord : data) {
            if (logRecord == null) continue;
            try {
                LogData logData = this.transLogData(logRecord);
                ProducerRecord record = new ProducerRecord(this.setting.getKafkaTopicLog(), (Object)logRecord.id().build(), (Object)Bytes.wrap((byte[])logData.toByteArray()));
                super.getProducer().send(record, (metadata, ex) -> {
                    if (ex != null) {
                        this.errorCounter.inc();
                        log.error("Failed to export Log.", (Throwable)ex);
                    } else {
                        this.successCounter.inc();
                    }
                });
            }
            catch (InvalidProtocolBufferException e) {
                throw new UnexpectedException("Failed to parse Log tags from LogRecord, id: " + logRecord.id() + ".", (Exception)((Object)e));
            }
        }
    }

    public void onError(List<LogRecord> data, Throwable t) {
    }

    private LogData transLogData(LogRecord logRecord) throws InvalidProtocolBufferException {
        LogData.Builder builder = LogData.newBuilder();
        LogDataBody.Builder bodyBuilder = LogDataBody.newBuilder();
        switch (ContentType.instanceOf((int)logRecord.getContentType())) {
            case JSON: {
                bodyBuilder.setType(ContentType.JSON.name());
                bodyBuilder.setJson(JSONLog.newBuilder().setJson(logRecord.getContent().getText()));
                break;
            }
            case YAML: {
                bodyBuilder.setType(ContentType.YAML.name());
                bodyBuilder.setYaml(YAMLLog.newBuilder().setYaml(logRecord.getContent().getText()));
                break;
            }
            case TEXT: {
                bodyBuilder.setType(ContentType.TEXT.name());
                bodyBuilder.setText(TextLog.newBuilder().setText(logRecord.getContent().getText()));
                break;
            }
            case NONE: {
                bodyBuilder.setType(ContentType.NONE.name());
                break;
            }
            default: {
                throw new UnexpectedException("Failed to parse Log ContentType value: " + logRecord.getContentType() + " from LogRecord, id: " + logRecord.id() + ".");
            }
        }
        builder.setBody(bodyBuilder);
        builder.setTimestamp(logRecord.getTimestamp());
        builder.setService(IDManager.ServiceID.analysisId((String)logRecord.getServiceId()).getName());
        if (StringUtil.isNotEmpty((String)logRecord.getServiceInstanceId())) {
            builder.setServiceInstance(IDManager.ServiceInstanceID.analysisId((String)logRecord.getServiceInstanceId()).getName());
        }
        if (StringUtil.isNotEmpty((String)logRecord.getEndpointId())) {
            builder.setEndpoint(IDManager.EndpointID.analysisId((String)logRecord.getEndpointId()).getEndpointName());
        }
        TraceContext.Builder contextBuilder = TraceContext.newBuilder();
        if (StringUtil.isNotEmpty((String)logRecord.getTraceSegmentId())) {
            contextBuilder.setTraceSegmentId(logRecord.getTraceSegmentId());
            contextBuilder.setSpanId(logRecord.getSpanId());
        }
        if (StringUtil.isNotEmpty((String)logRecord.getTraceId())) {
            contextBuilder.setTraceId(logRecord.getTraceId());
        }
        builder.setTraceContext(contextBuilder);
        if (logRecord.getTagsRawData() != null) {
            builder.setTags(LogTags.parseFrom((byte[])logRecord.getTagsRawData()));
        }
        return builder.build();
    }
}

