/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.util;

import java.util.NoSuchElementException;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Arrays {
    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        return java.util.Arrays.equals(byArray, byArray2);
    }

    public static boolean areEqual(char[] cArray, char[] cArray2) {
        return java.util.Arrays.equals(cArray, cArray2);
    }

    public static boolean areEqual(int[] nArray, int[] nArray2) {
        return java.util.Arrays.equals(nArray, nArray2);
    }

    public static boolean areEqual(short[] sArray, short[] sArray2) {
        return java.util.Arrays.equals(sArray, sArray2);
    }

    public static boolean constantTimeAreEqual(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray == byArray2) {
            return true;
        }
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n3 = byArray.length ^ byArray2.length;
        for (n = 0; n != n2; ++n) {
            n3 |= byArray[n] ^ byArray2[n];
        }
        for (n = n2; n < byArray2.length; ++n) {
            n3 |= byArray2[n] ^ ~byArray2[n];
        }
        return n3 == 0;
    }

    public static void fill(byte[] byArray, byte by) {
        java.util.Arrays.fill(byArray, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        java.util.Arrays.fill(byArray, n, n2, by);
    }

    public static void fill(int[] nArray, int n) {
        java.util.Arrays.fill(nArray, n);
    }

    public static void fill(long[] lArray, long l) {
        java.util.Arrays.fill(lArray, l);
    }

    public static void fill(short[] sArray, short s) {
        java.util.Arrays.fill(sArray, s);
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= byArray[n];
        }
        return n2;
    }

    public static int hashCode(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            n4 *= 257;
            n4 ^= byArray[n + n3];
        }
        return n4;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = cArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= cArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = nArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= nArray[n];
        }
        return n2;
    }

    public static int hashCode(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            n4 *= 257;
            n4 ^= nArray[n + n3];
        }
        return n4;
    }

    public static int hashCode(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return 0;
        }
        int n3 = n2;
        int n4 = n3 + 1;
        while (--n3 >= 0) {
            long l = lArray[n + n3];
            n4 *= 257;
            n4 ^= (int)l;
            n4 *= 257;
            n4 ^= (int)(l >>> 32);
        }
        return n4;
    }

    public static int hashCode(short[][][] sArray) {
        int n = 0;
        for (int i = 0; i != sArray.length; ++i) {
            n = n * 257 + Arrays.hashCode(sArray[i]);
        }
        return n;
    }

    public static int hashCode(short[][] sArray) {
        int n = 0;
        for (int i = 0; i != sArray.length; ++i) {
            n = n * 257 + Arrays.hashCode(sArray[i]);
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = sArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= sArray[n] & 0xFF;
        }
        return n2;
    }

    public static boolean[] clone(boolean[] blArray) {
        return null == blArray ? null : (boolean[])blArray.clone();
    }

    public static byte[] clone(byte[] byArray) {
        return null == byArray ? null : (byte[])byArray.clone();
    }

    public static int[] clone(int[] nArray) {
        return null == nArray ? null : (int[])nArray.clone();
    }

    public static long[] clone(long[] lArray) {
        return null == lArray ? null : (long[])lArray.clone();
    }

    public static short[] clone(short[] sArray) {
        return null == sArray ? null : (short[])sArray.clone();
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        int n3 = Arrays.getLength(n, n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    public static int[] copyOfRange(int[] nArray, int n, int n2) {
        int n3 = Arrays.getLength(n, n2);
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n, nArray2, 0, Math.min(nArray.length - n, n3));
        return nArray2;
    }

    private static int getLength(int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            stringBuffer.append(" > ").append(n2);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return n3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (null == byArray) {
            return Arrays.clone(byArray2);
        }
        if (null == byArray2) {
            return Arrays.clone(byArray);
        }
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (null == byArray) {
            return Arrays.concatenate(byArray2, byArray3);
        }
        if (null == byArray2) {
            return Arrays.concatenate(byArray, byArray3);
        }
        if (null == byArray3) {
            return Arrays.concatenate(byArray, byArray2);
        }
        byte[] byArray4 = new byte[byArray.length + byArray2.length + byArray3.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray4, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray4, n += byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, n += byArray2.length, byArray3.length);
        return byArray4;
    }

    public static byte[] concatenate(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (null == byArray) {
            return Arrays.concatenate(byArray2, byArray3, byArray4);
        }
        if (null == byArray2) {
            return Arrays.concatenate(byArray, byArray3, byArray4);
        }
        if (null == byArray3) {
            return Arrays.concatenate(byArray, byArray2, byArray4);
        }
        if (null == byArray4) {
            return Arrays.concatenate(byArray, byArray2, byArray3);
        }
        byte[] byArray5 = new byte[byArray.length + byArray2.length + byArray3.length + byArray4.length];
        int n = 0;
        System.arraycopy(byArray, 0, byArray5, n, byArray.length);
        System.arraycopy(byArray2, 0, byArray5, n += byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, n += byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, n += byArray3.length, byArray4.length);
        return byArray5;
    }

    public static byte[] prepend(byte[] byArray, byte by) {
        if (byArray == null) {
            return new byte[]{by};
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 1];
        System.arraycopy(byArray, 0, byArray2, 1, n);
        byArray2[0] = by;
        return byArray2;
    }

    public static int[] reverseInPlace(int[] nArray) {
        if (null == nArray) {
            return null;
        }
        int n = 0;
        int n2 = nArray.length - 1;
        while (n < n2) {
            int n3 = nArray[n];
            int n4 = nArray[n2];
            nArray[n++] = n4;
            nArray[n2--] = n3;
        }
        return nArray;
    }

    public static void clear(byte[] byArray) {
        if (null != byArray) {
            java.util.Arrays.fill(byArray, (byte)0);
        }
    }

    public static boolean isNullOrContainsNull(Object[] objectArray) {
        if (null == objectArray) {
            return true;
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (null != objectArray[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] dataArray;
        private int position = 0;

        public Iterator(T[] TArray) {
            this.dataArray = TArray;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.dataArray.length;
        }

        @Override
        public T next() {
            if (this.position == this.dataArray.length) {
                throw new NoSuchElementException("Out of elements: " + this.position);
            }
            return this.dataArray[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

