/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public interface Cursor<T>
extends CloseableIterator<T> {
    public CursorId getId();

    @Deprecated(since="3.3.0")
    public long getCursorId();

    public boolean isClosed();

    public long getPosition();

    public static abstract class CursorId {
        private static final CursorId INITIAL = new CursorId(){

            @Override
            public String getCursorId() {
                return "0";
            }
        };

        public static CursorId initial() {
            return INITIAL;
        }

        public static CursorId of(final String cursorId) {
            Assert.notNull((Object)cursorId, (String)"CursorId must not be null");
            if (INITIAL.getCursorId().equals(cursorId)) {
                return INITIAL;
            }
            return new CursorId(){

                @Override
                public String getCursorId() {
                    return cursorId;
                }
            };
        }

        public static CursorId of(long cursorId) {
            if (cursorId == 0L) {
                return INITIAL;
            }
            return CursorId.of(Long.toUnsignedString(cursorId));
        }

        public static boolean isInitial(String cursorId) {
            return INITIAL.getCursorId().equals(cursorId);
        }

        public boolean isInitial() {
            return INITIAL.getCursorId().equals(this.getCursorId());
        }

        public abstract String getCursorId();

        public int hashCode() {
            return this.getCursorId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CursorId) {
                CursorId other = (CursorId)obj;
                return this.getCursorId().equals(other.getCursorId());
            }
            return false;
        }

        public String toString() {
            return this.getCursorId();
        }
    }
}

