/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics;

import java.util.Properties;
import org.apache.shardingsphere.elasticjob.cloud.scheduler.statistics.job.StatisticJob;
import org.apache.shardingsphere.elasticjob.infra.exception.JobStatisticException;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.plugins.management.ShutdownHookPlugin;
import org.quartz.simpl.SimpleThreadPool;

final class StatisticsScheduler {
    private final StdSchedulerFactory factory = new StdSchedulerFactory();
    private Scheduler scheduler;

    StatisticsScheduler() {
        try {
            this.factory.initialize(this.getQuartzProperties());
        }
        catch (SchedulerException ex) {
            throw new JobStatisticException((Exception)((Object)ex));
        }
    }

    private Properties getQuartzProperties() {
        Properties result = new Properties();
        result.put("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        result.put("org.quartz.threadPool.threadCount", Integer.toString(1));
        result.put("org.quartz.scheduler.instanceName", "ELASTIC_JOB_CLOUD_STATISTICS_SCHEDULER");
        result.put("org.quartz.plugin.shutdownhook.class", ShutdownHookPlugin.class.getName());
        result.put("org.quartz.plugin.shutdownhook.cleanShutdown", Boolean.TRUE.toString());
        return result;
    }

    void start() {
        try {
            this.scheduler = this.factory.getScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new JobStatisticException((Exception)((Object)ex));
        }
    }

    void register(StatisticJob statisticJob) {
        try {
            JobDetail jobDetail = statisticJob.buildJobDetail();
            jobDetail.getJobDataMap().putAll(statisticJob.getDataMap());
            this.scheduler.scheduleJob(jobDetail, statisticJob.buildTrigger());
        }
        catch (SchedulerException ex) {
            throw new JobStatisticException((Exception)((Object)ex));
        }
    }

    void shutdown() {
        try {
            if (null != this.scheduler && !this.scheduler.isShutdown()) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException ex) {
            throw new JobStatisticException((Exception)((Object)ex));
        }
    }
}

