/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.fenzo;

import com.netflix.fenzo.AssignmentFailure;
import com.netflix.fenzo.PreferentialNamedConsumableResourceSet;
import com.netflix.fenzo.SchedulingResult;
import com.netflix.fenzo.TaskAssignmentResult;
import com.netflix.fenzo.TaskRequest;
import com.netflix.fenzo.TaskScheduler;
import com.netflix.fenzo.VMAssignmentResult;
import com.netflix.fenzo.VMResource;
import com.netflix.fenzo.VirtualMachineCurrentState;
import com.netflix.fenzo.VirtualMachineLease;
import com.netflix.fenzo.functions.Action0;
import com.netflix.fenzo.functions.Action1;
import com.netflix.fenzo.functions.Func1;
import com.netflix.fenzo.queues.InternalTaskQueue;
import com.netflix.fenzo.queues.QAttributes;
import com.netflix.fenzo.queues.QueuableTask;
import com.netflix.fenzo.queues.TaskQueue;
import com.netflix.fenzo.queues.TaskQueueException;
import com.netflix.fenzo.queues.TaskQueueMultiException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSchedulingService {
    private static final Logger logger = LoggerFactory.getLogger(TaskSchedulingService.class);
    private final TaskScheduler taskScheduler;
    private final Action1<SchedulingResult> schedulingResultCallback;
    private final InternalTaskQueue taskQueue;
    private final ScheduledExecutorService executorService;
    private final long loopIntervalMillis;
    private final Action0 preHook;
    private final BlockingQueue<VirtualMachineLease> leaseBlockingQueue = new LinkedBlockingQueue<VirtualMachineLease>();
    private final BlockingQueue<Map<String, QueuableTask>> addRunningTasksQueue = new LinkedBlockingQueue<Map<String, QueuableTask>>();
    private final BlockingQueue<RemoveTaskRequest> removeTasksQueue = new LinkedBlockingQueue<RemoveTaskRequest>();
    private final BlockingQueue<SetReadyTimeRequest> setReadyTimeQueue = new LinkedBlockingQueue<SetReadyTimeRequest>();
    private final BlockingQueue<Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>>> taskMapRequest = new LinkedBlockingQueue<Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>>>(10);
    private final BlockingQueue<Action1<Map<String, Map<VMResource, Double[]>>>> resStatusRequest = new LinkedBlockingQueue<Action1<Map<String, Map<VMResource, Double[]>>>>(10);
    private final BlockingQueue<Action1<List<VirtualMachineCurrentState>>> vmCurrStateRequest = new LinkedBlockingQueue<Action1<List<VirtualMachineCurrentState>>>(10);
    private final AtomicLong lastSchedIterationAt = new AtomicLong();
    private final long maxSchedIterDelay;
    private volatile Func1<QueuableTask, List<String>> taskToClusterAutoScalerMapGetter = null;

    private TaskSchedulingService(Builder builder) {
        this.taskScheduler = builder.taskScheduler;
        this.schedulingResultCallback = builder.schedulingResultCallback;
        this.taskQueue = builder.taskQueue;
        this.taskScheduler.getTaskTracker().setUsageTrackedQueue(this.taskQueue.getUsageTracker());
        this.taskScheduler.setUsingSchedulingService(true);
        this.executorService = builder.executorService;
        this.loopIntervalMillis = builder.loopIntervalMillis;
        this.preHook = builder.preHook;
        this.maxSchedIterDelay = Math.max(builder.maxDelayMillis, this.loopIntervalMillis);
    }

    public void start() {
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                TaskSchedulingService.this.scheduleOnce();
            }
        }, 0L, this.loopIntervalMillis, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    TaskQueue getQueue() {
        return this.taskQueue;
    }

    Map<String, Integer> requestPseudoScheduling(InternalTaskQueue pTaskQueue, Map<String, Integer> groupCounts) {
        HashMap<String, Integer> pseudoSchedulingResult = new HashMap<String, Integer>();
        try {
            logger.debug("Creating pseudo hosts");
            Map<String, List<String>> pseudoHosts = this.taskScheduler.createPseudoHosts(groupCounts);
            logger.debug("Created " + pseudoHosts.size() + " pseudoHost groups");
            int pHostsAdded = 0;
            for (Map.Entry<String, List<String>> entry : pseudoHosts.entrySet()) {
                logger.debug("Pseudo hosts for group " + entry.getKey() + ": " + entry.getValue());
                pHostsAdded += entry.getValue() == null ? 0 : entry.getValue().size();
            }
            try {
                HashMap<String, String> hostnameToGrpMap = new HashMap<String, String>();
                for (Map.Entry<String, List<String>> entry : pseudoHosts.entrySet()) {
                    for (String string : entry.getValue()) {
                        hostnameToGrpMap.put(string, entry.getKey());
                    }
                }
                try {
                    pTaskQueue.reset();
                }
                catch (TaskQueueMultiException taskQueueMultiException) {
                    List<Exception> list = taskQueueMultiException.getExceptions();
                    if (list == null || list.isEmpty()) {
                        logger.error("Error with pseudo queue, no details available");
                    }
                    logger.error("Error with pseudo queue, details:");
                    for (Exception exception : list) {
                        logger.error("pseudo queue error detail: " + exception.getMessage());
                    }
                }
                this.taskScheduler.getTaskTracker().setUsageTrackedQueue(pTaskQueue.getUsageTracker());
                logger.debug("Scheduling with pseudoQ");
                SchedulingResult schedulingResult = this.taskScheduler.pseudoScheduleOnce(pTaskQueue);
                Map<String, VMAssignmentResult> map = schedulingResult.getResultMap();
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                if (!map.isEmpty()) {
                    for (String h : map.keySet()) {
                        String grp = (String)hostnameToGrpMap.get(h);
                        if (grp == null) continue;
                        Integer count = (Integer)result.get(grp);
                        if (count == null) {
                            result.put(grp, 1);
                            continue;
                        }
                        result.put(grp, count + 1);
                    }
                } else if (pHostsAdded > 0) {
                    logger.debug("No pseudo assignments made, looking for failures");
                    Map<TaskRequest, List<TaskAssignmentResult>> map2 = schedulingResult.getFailures();
                    if (map2 == null || map2.isEmpty()) {
                        logger.debug("No failures found for pseudo assignments");
                    } else {
                        for (Map.Entry<TaskRequest, List<TaskAssignmentResult>> entry : map2.entrySet()) {
                            List<TaskAssignmentResult> tars = entry.getValue();
                            if (tars == null || tars.isEmpty()) {
                                logger.debug("No pseudo assignment failures for task " + entry.getKey());
                                continue;
                            }
                            StringBuilder b = new StringBuilder("Pseudo assignment failures for task ").append(entry.getKey()).append(": ");
                            for (TaskAssignmentResult r : tars) {
                                b.append("HOST: ").append(r.getHostname()).append(":");
                                List<AssignmentFailure> afs = r.getFailures();
                                if (afs != null && !afs.isEmpty()) {
                                    afs.forEach(af -> b.append(af.getMessage()).append("; "));
                                    continue;
                                }
                                b.append("None").append(";");
                            }
                            logger.debug(b.toString());
                        }
                    }
                }
                pseudoSchedulingResult = result;
            }
            catch (Exception e) {
                logger.error("Error in pseudo scheduling", (Throwable)e);
                throw e;
            }
            finally {
                this.taskScheduler.removePseudoHosts(pseudoHosts);
                this.taskScheduler.removePseudoAssignments();
                this.taskScheduler.getTaskTracker().setUsageTrackedQueue(this.taskQueue.getUsageTracker());
            }
        }
        catch (Exception e) {
            logger.error("Error in pseudo scheduling", (Throwable)e);
        }
        return pseudoSchedulingResult;
    }

    private void scheduleOnce() {
        try {
            this.taskScheduler.checkIfShutdown();
        }
        catch (IllegalStateException e) {
            logger.warn("Shutting down due to taskScheduler being shutdown");
            this.shutdown();
            return;
        }
        try {
            boolean newLeaseExists;
            boolean qModified = this.taskQueue.reset();
            this.addPendingRunningTasks();
            this.removeTasks();
            this.setTaskReadyTimes();
            boolean bl = newLeaseExists = this.leaseBlockingQueue.peek() != null;
            if (qModified || newLeaseExists || this.doNextIteration()) {
                this.taskScheduler.setTaskToClusterAutoScalerMapGetter(this.taskToClusterAutoScalerMapGetter);
                this.lastSchedIterationAt.set(System.currentTimeMillis());
                if (this.preHook != null) {
                    this.preHook.call();
                }
                ArrayList<VirtualMachineLease> currentLeases = new ArrayList<VirtualMachineLease>();
                this.leaseBlockingQueue.drainTo(currentLeases);
                SchedulingResult schedulingResult = this.taskScheduler.scheduleOnce(this.taskQueue, currentLeases);
                this.taskQueue.getUsageTracker().reset();
                this.assignTasks(schedulingResult, this.taskScheduler);
                this.schedulingResultCallback.call(schedulingResult);
                this.doPendingActions();
            }
        }
        catch (Exception e) {
            SchedulingResult result = new SchedulingResult(null);
            result.addException(e);
            this.schedulingResultCallback.call(result);
        }
    }

    private void addPendingRunningTasks() {
        if (this.addRunningTasksQueue.peek() != null) {
            LinkedList r = new LinkedList();
            this.addRunningTasksQueue.drainTo(r);
            for (Map m : r) {
                for (Map.Entry entry : m.entrySet()) {
                    this.taskScheduler.getTaskAssignerIntl().call((TaskRequest)entry.getValue(), (String)entry.getKey());
                }
            }
        }
    }

    private void removeTasks() {
        if (this.removeTasksQueue.peek() != null) {
            LinkedList l = new LinkedList();
            this.removeTasksQueue.drainTo(l);
            for (RemoveTaskRequest r : l) {
                try {
                    this.taskQueue.getUsageTracker().removeTask(r.taskId, r.qAttributes);
                }
                catch (TaskQueueException e1) {
                    logger.warn("Unexpected to get exception outside of scheduling iteration: " + e1.getMessage(), (Throwable)e1);
                }
                if (r.hostname == null) continue;
                this.taskScheduler.getTaskUnAssigner().call(r.taskId, r.hostname);
            }
        }
    }

    private void setTaskReadyTimes() {
        if (this.setReadyTimeQueue.peek() != null) {
            LinkedList l = new LinkedList();
            this.setReadyTimeQueue.drainTo(l);
            l.forEach(r -> {
                try {
                    this.taskQueue.getUsageTracker().setTaskReadyTime(((SetReadyTimeRequest)r).taskId, ((SetReadyTimeRequest)r).qAttributes, ((SetReadyTimeRequest)r).when);
                }
                catch (TaskQueueException e) {
                    logger.warn("Unexpected to get exception outside of scheduling iteration: " + e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    private void doPendingActions() {
        Action1 action = (Action1)this.taskMapRequest.poll();
        try {
            if (action != null) {
                action.call(this.taskQueue.getAllTasks());
            }
        }
        catch (TaskQueueException e) {
            logger.warn("Unexpected when trying to get task list: " + e.getMessage(), (Throwable)e);
        }
        Action1 rsAction = (Action1)this.resStatusRequest.poll();
        try {
            if (rsAction != null) {
                rsAction.call(this.taskScheduler.getResourceStatusIntl());
            }
        }
        catch (IllegalStateException e) {
            logger.warn("Unexpected when trying to get resource status: " + e.getMessage(), (Throwable)e);
        }
        Action1 vmcAction = (Action1)this.vmCurrStateRequest.poll();
        try {
            if (vmcAction != null) {
                vmcAction.call(this.taskScheduler.getVmCurrentStatesIntl());
            }
        }
        catch (IllegalStateException e) {
            logger.warn("Unexpected when trying to get vm current states: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean doNextIteration() {
        return System.currentTimeMillis() - this.lastSchedIterationAt.get() > this.maxSchedIterDelay;
    }

    private void assignTasks(SchedulingResult schedulingResult, TaskScheduler taskScheduler) {
        if (!schedulingResult.getResultMap().isEmpty()) {
            for (VMAssignmentResult result : schedulingResult.getResultMap().values()) {
                for (TaskAssignmentResult t : result.getTasksAssigned()) {
                    taskScheduler.getTaskAssignerIntl().call(t.getRequest(), result.getHostname());
                    List<PreferentialNamedConsumableResourceSet.ConsumeResult> rSets = t.getrSets();
                    if (rSets == null) continue;
                    TaskRequest.AssignedResources assignedResources = new TaskRequest.AssignedResources();
                    assignedResources.setConsumedNamedResources(rSets);
                    t.getRequest().setAssignedResources(assignedResources);
                }
            }
        }
    }

    public void addLeases(List<? extends VirtualMachineLease> leases) {
        if (leases != null && !leases.isEmpty()) {
            for (VirtualMachineLease virtualMachineLease : leases) {
                this.leaseBlockingQueue.offer(virtualMachineLease);
            }
        }
    }

    public void requestAllTasks(Action1<Map<TaskQueue.TaskState, Collection<QueuableTask>>> action) throws TaskQueueException {
        if (!this.taskMapRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting tasks collection");
        }
    }

    public void requestResourceStatus(Action1<Map<String, Map<VMResource, Double[]>>> action) throws TaskQueueException {
        if (!this.resStatusRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting resource status");
        }
    }

    public void requestVmCurrentStates(Action1<List<VirtualMachineCurrentState>> action) throws TaskQueueException {
        if (!this.vmCurrStateRequest.offer(action)) {
            throw new TaskQueueException("Too many pending actions submitted for getting VM current state");
        }
    }

    public void initializeRunningTask(QueuableTask task, String hostname) {
        this.addRunningTasksQueue.offer(Collections.singletonMap(hostname, task));
    }

    public void removeTask(String taskId, QAttributes qAttributes, String hostname) {
        this.removeTasksQueue.offer(new RemoveTaskRequest(taskId, qAttributes, hostname));
    }

    public void setTaskReadyTime(String taskId, QAttributes attributes, long when) {
        this.setReadyTimeQueue.offer(new SetReadyTimeRequest(taskId, attributes, when));
    }

    public void setTaskToClusterAutoScalerMapGetter(Func1<QueuableTask, List<String>> getter) {
        this.taskToClusterAutoScalerMapGetter = getter;
    }

    public static final class Builder {
        private TaskScheduler taskScheduler = null;
        private Action1<SchedulingResult> schedulingResultCallback = null;
        private InternalTaskQueue taskQueue = null;
        private long loopIntervalMillis = 50L;
        private final ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1);
        private Action0 preHook = null;
        private long maxDelayMillis = 5000L;
        private boolean optimizingShortfallEvaluator = false;

        public Builder withTaskScheduler(TaskScheduler taskScheduler) {
            this.taskScheduler = taskScheduler;
            return this;
        }

        public Builder withSchedulingResultCallback(Action1<SchedulingResult> callback) {
            this.schedulingResultCallback = callback;
            return this;
        }

        public Builder withTaskQueue(TaskQueue taskQ) {
            if (!(taskQ instanceof InternalTaskQueue)) {
                throw new IllegalArgumentException("Argument is not a valid implementation of task queue");
            }
            this.taskQueue = (InternalTaskQueue)taskQ;
            return this;
        }

        public Builder withLoopIntervalMillis(long loopIntervalMillis) {
            this.loopIntervalMillis = loopIntervalMillis;
            return this;
        }

        public Builder withMaxDelayMillis(long maxDelayMillis) {
            this.maxDelayMillis = maxDelayMillis;
            return this;
        }

        public Builder withPreSchedulingLoopHook(Action0 preHook) {
            this.preHook = preHook;
            return this;
        }

        public Builder withOptimizingShortfallEvaluator() {
            this.optimizingShortfallEvaluator = true;
            return this;
        }

        public TaskSchedulingService build() {
            if (this.taskScheduler == null) {
                throw new NullPointerException("Null task scheduler not allowed");
            }
            if (this.schedulingResultCallback == null) {
                throw new NullPointerException("Null scheduling result callback not allowed");
            }
            if (this.taskQueue == null) {
                throw new NullPointerException("Null task queue not allowed");
            }
            TaskSchedulingService schedulingService = new TaskSchedulingService(this);
            if (this.optimizingShortfallEvaluator) {
                this.taskScheduler.getAutoScaler().useOptimizingShortfallAnalyzer();
                this.taskScheduler.getAutoScaler().setSchedulingService(schedulingService);
            }
            return schedulingService;
        }
    }

    private static class SetReadyTimeRequest {
        private final String taskId;
        private final QAttributes qAttributes;
        private final long when;

        private SetReadyTimeRequest(String taskId, QAttributes qAttributes, long when) {
            this.taskId = taskId;
            this.qAttributes = qAttributes;
            this.when = when;
        }
    }

    private static class RemoveTaskRequest {
        private final String taskId;
        private final QAttributes qAttributes;
        private final String hostname;

        public RemoveTaskRequest(String taskId, QAttributes qAttributes, String hostname) {
            this.taskId = taskId;
            this.qAttributes = qAttributes;
            this.hostname = hostname;
        }
    }
}

