/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.infra.spi;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.infra.spi.SPIPostProcessor;
import org.apache.shardingsphere.elasticjob.infra.spi.TypedSPI;
import org.apache.shardingsphere.elasticjob.infra.spi.exception.ServiceLoaderInstantiationException;

public final class ElasticJobServiceLoader {
    private static final ConcurrentMap<Class<? extends TypedSPI>, ConcurrentMap<String, TypedSPI>> TYPED_SERVICES = new ConcurrentHashMap<Class<? extends TypedSPI>, ConcurrentMap<String, TypedSPI>>();
    private static final ConcurrentMap<Class<? extends TypedSPI>, ConcurrentMap<String, Class<? extends TypedSPI>>> TYPED_SERVICE_CLASSES = new ConcurrentHashMap<Class<? extends TypedSPI>, ConcurrentMap<String, Class<? extends TypedSPI>>>();

    public static <T extends TypedSPI> void registerTypedService(Class<T> typedService) {
        if (TYPED_SERVICES.containsKey(typedService)) {
            return;
        }
        ServiceLoader.load(typedService).forEach(each -> ElasticJobServiceLoader.registerTypedServiceClass(typedService, each));
    }

    private static <T extends TypedSPI> void registerTypedServiceClass(Class<T> typedService, TypedSPI instance) {
        TYPED_SERVICES.computeIfAbsent(typedService, unused -> new ConcurrentHashMap()).putIfAbsent(instance.getType(), instance);
        TYPED_SERVICE_CLASSES.computeIfAbsent(typedService, unused -> new ConcurrentHashMap()).putIfAbsent(instance.getType(), instance.getClass());
    }

    public static <T extends TypedSPI> Optional<T> getCachedTypedServiceInstance(Class<T> typedServiceInterface, String type) {
        return Optional.ofNullable((ConcurrentMap)TYPED_SERVICES.get(typedServiceInterface)).map(services -> (TypedSPI)services.get(type));
    }

    public static <T extends TypedSPI> Optional<T> newTypedServiceInstance(Class<T> typedServiceInterface, String type, Properties props) {
        Optional<TypedSPI> result = Optional.ofNullable((ConcurrentMap)TYPED_SERVICE_CLASSES.get(typedServiceInterface)).map(serviceClasses -> (Class)serviceClasses.get(type)).map(clazz -> (TypedSPI)ElasticJobServiceLoader.newServiceInstance(clazz));
        if (result.isPresent() && result.get() instanceof SPIPostProcessor) {
            ((SPIPostProcessor)((Object)result.get())).init(props);
        }
        return result;
    }

    private static Object newServiceInstance(Class<?> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
            throw new ServiceLoaderInstantiationException(clazz, (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new ServiceLoaderInstantiationException(clazz, ex.getCause());
        }
    }

    @Generated
    private ElasticJobServiceLoader() {
    }
}

