/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.database.core.metadata.database.DialectDatabaseMetaData;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.engine.merger.ResultMerger;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.session.connection.ConnectionContext;
import org.apache.shardingsphere.sharding.merge.common.IteratorStreamMergedResult;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByMemoryMergedResult;
import org.apache.shardingsphere.sharding.merge.dql.groupby.GroupByStreamMergedResult;
import org.apache.shardingsphere.sharding.merge.dql.orderby.OrderByStreamMergedResult;
import org.apache.shardingsphere.sharding.merge.dql.pagination.builder.PaginationDecoratorMergedResultBuilder;
import org.apache.shardingsphere.sql.parser.statement.core.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.util.SQLUtils;

public final class ShardingDQLResultMerger
implements ResultMerger {
    private final DatabaseType protocolType;

    public MergedResult merge(List<QueryResult> queryResults, SQLStatementContext sqlStatementContext, ShardingSphereDatabase database, ConnectionContext connectionContext) throws SQLException {
        if (1 == queryResults.size() && !this.isNeedAggregateRewrite(sqlStatementContext)) {
            return new IteratorStreamMergedResult(queryResults);
        }
        Map<String, Integer> columnLabelIndexMap = this.getColumnLabelIndexMap(queryResults.get(0));
        SelectStatementContext selectStatementContext = (SelectStatementContext)sqlStatementContext;
        selectStatementContext.setIndexes(columnLabelIndexMap);
        MergedResult mergedResult = this.build(queryResults, selectStatementContext, columnLabelIndexMap, database);
        return this.decorate(queryResults, selectStatementContext, mergedResult);
    }

    private boolean isNeedAggregateRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isNeedAggregateRewrite();
    }

    private Map<String, Integer> getColumnLabelIndexMap(QueryResult queryResult) throws SQLException {
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        for (int i = queryResult.getMetaData().getColumnCount(); i > 0; --i) {
            result.put(SQLUtils.getExactlyValue((String)queryResult.getMetaData().getColumnLabel(i)), i);
        }
        return result;
    }

    private MergedResult build(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, Map<String, Integer> columnLabelIndexMap, ShardingSphereDatabase database) throws SQLException {
        String defaultSchemaName = new DatabaseTypeRegistry(selectStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        ShardingSphereSchema schema = selectStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
        if (this.isNeedProcessGroupBy(selectStatementContext)) {
            return this.getGroupByMergedResult(queryResults, selectStatementContext, columnLabelIndexMap, schema);
        }
        if (this.isNeedProcessDistinctRow(selectStatementContext)) {
            this.setGroupByForDistinctRow(selectStatementContext);
            return this.getGroupByMergedResult(queryResults, selectStatementContext, columnLabelIndexMap, schema);
        }
        if (this.isNeedProcessOrderBy(selectStatementContext)) {
            return new OrderByStreamMergedResult(queryResults, selectStatementContext, schema);
        }
        return new IteratorStreamMergedResult(queryResults);
    }

    private boolean isNeedProcessGroupBy(SelectStatementContext selectStatementContext) {
        return !selectStatementContext.getGroupByContext().getItems().isEmpty() || !selectStatementContext.getProjectionsContext().getAggregationProjections().isEmpty();
    }

    private boolean isNeedProcessDistinctRow(SelectStatementContext selectStatementContext) {
        return selectStatementContext.getProjectionsContext().isDistinctRow();
    }

    private void setGroupByForDistinctRow(SelectStatementContext selectStatementContext) {
        DialectDatabaseMetaData dialectDatabaseMetaData = new DatabaseTypeRegistry(selectStatementContext.getSqlStatement().getDatabaseType()).getDialectDatabaseMetaData();
        for (int index = 1; index <= selectStatementContext.getProjectionsContext().getExpandProjections().size(); ++index) {
            OrderByItem orderByItem = new OrderByItem((OrderByItemSegment)new IndexOrderByItemSegment(-1, -1, index, OrderDirection.ASC, dialectDatabaseMetaData.getDefaultNullsOrderType()));
            orderByItem.setIndex(index);
            selectStatementContext.getGroupByContext().getItems().add(orderByItem);
        }
    }

    private MergedResult getGroupByMergedResult(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, Map<String, Integer> columnLabelIndexMap, ShardingSphereSchema schema) throws SQLException {
        return selectStatementContext.isSameGroupByAndOrderByItems() ? new GroupByStreamMergedResult(columnLabelIndexMap, queryResults, selectStatementContext, schema) : new GroupByMemoryMergedResult(queryResults, selectStatementContext, schema);
    }

    private boolean isNeedProcessOrderBy(SelectStatementContext selectStatementContext) {
        return !selectStatementContext.getOrderByContext().getItems().isEmpty();
    }

    private MergedResult decorate(List<QueryResult> queryResults, SelectStatementContext selectStatementContext, MergedResult mergedResult) throws SQLException {
        PaginationContext paginationContext = selectStatementContext.getPaginationContext();
        if (!paginationContext.isHasPagination() || 1 == queryResults.size()) {
            return mergedResult;
        }
        Optional paginationDecoratorMergedResultBuilder = DatabaseTypedSPILoader.findService(PaginationDecoratorMergedResultBuilder.class, (DatabaseType)this.protocolType);
        return paginationDecoratorMergedResultBuilder.isPresent() ? ((PaginationDecoratorMergedResultBuilder)paginationDecoratorMergedResultBuilder.get()).build(mergedResult, paginationContext) : mergedResult;
    }

    @Generated
    public ShardingDQLResultMerger(DatabaseType protocolType) {
        this.protocolType = protocolType;
    }
}

