/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.task;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.importer.Importer;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.TaskExecuteCallback;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;

public final class IncrementalTask
implements PipelineTask {
    private final String taskId;
    private final PipelineExecuteEngine incrementalExecuteEngine;
    private final Dumper dumper;
    private final Collection<Importer> importers;
    private final IncrementalTaskProgress taskProgress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CompletableFuture<?>> start() {
        this.taskProgress.getIncrementalTaskDelay().setLatestActiveTimeMillis(System.currentTimeMillis());
        LinkedList result = new LinkedList();
        PipelineExecuteEngine pipelineExecuteEngine = this.incrementalExecuteEngine;
        synchronized (pipelineExecuteEngine) {
            result.add(this.incrementalExecuteEngine.submit(this.dumper, new TaskExecuteCallback(this)));
            this.importers.forEach(each -> result.add(this.incrementalExecuteEngine.submit((PipelineLifecycleRunnable)each, new TaskExecuteCallback(this))));
        }
        return result;
    }

    @Override
    public void stop() {
        this.dumper.stop();
        this.importers.forEach(PipelineLifecycleRunnable::stop);
    }

    @Generated
    public IncrementalTask(String taskId, PipelineExecuteEngine incrementalExecuteEngine, Dumper dumper, Collection<Importer> importers, IncrementalTaskProgress taskProgress) {
        this.taskId = taskId;
        this.incrementalExecuteEngine = incrementalExecuteEngine;
        this.dumper = dumper;
        this.importers = importers;
        this.taskProgress = taskProgress;
    }

    @Generated
    public String toString() {
        return "IncrementalTask(taskId=" + this.getTaskId() + ")";
    }

    @Override
    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    @Generated
    public IncrementalTaskProgress getTaskProgress() {
        return this.taskProgress;
    }
}

