/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql.BuildDivisibleSQLParameter;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;

public final class PipelineInventoryDumpSQLBuilder {
    private final DialectPipelineSQLBuilder dialectSQLBuilder;
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;

    public PipelineInventoryDumpSQLBuilder(DatabaseType databaseType) {
        this.dialectSQLBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType);
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
    }

    public String buildDivisibleSQL(BuildDivisibleSQLParameter param) {
        String queryColumns = this.buildQueryColumns(param.getColumnNames());
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(param.getSchemaName(), param.getTableName());
        String escapedUniqueKey = this.sqlSegmentBuilder.getEscapedIdentifier(param.getUniqueKey());
        String operator = param.isLowerInclusive() ? ">=" : ">";
        String sql = param.isLimited() ? String.format("SELECT %s FROM %s WHERE %s%s? AND %s<=? ORDER BY %s ASC", queryColumns, qualifiedTableName, escapedUniqueKey, operator, escapedUniqueKey, escapedUniqueKey) : String.format("SELECT %s FROM %s WHERE %s%s? ORDER BY %s ASC", queryColumns, qualifiedTableName, escapedUniqueKey, operator, escapedUniqueKey);
        return this.dialectSQLBuilder.wrapWithPageQuery(sql);
    }

    public String buildIndivisibleSQL(String schemaName, String tableName, Collection<String> columnNames, String uniqueKey) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName);
        String quotedUniqueKey = this.sqlSegmentBuilder.getEscapedIdentifier(uniqueKey);
        return String.format("SELECT %s FROM %s ORDER BY %s ASC", this.buildQueryColumns(columnNames), qualifiedTableName, quotedUniqueKey);
    }

    private String buildQueryColumns(Collection<String> columnNames) {
        return columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
    }

    public String buildPointQuerySQL(String schemaName, String tableName, Collection<String> columnNames, String uniqueKey) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        String escapedUniqueKey = this.sqlSegmentBuilder.getEscapedIdentifier(uniqueKey);
        return String.format("SELECT %s FROM %s WHERE %s=?", queryColumns, qualifiedTableName, escapedUniqueKey);
    }

    public String buildFetchAllSQL(String schemaName, String tableName, Collection<String> columnNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(schemaName, tableName);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        return String.format("SELECT %s FROM %s", queryColumns, qualifiedTableName);
    }
}

