/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.range.QueryRange;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class PipelineDataConsistencyCalculateSQLBuilder {
    private final DialectPipelineSQLBuilder dialectSQLBuilder;
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;

    public PipelineDataConsistencyCalculateSQLBuilder(DatabaseType databaseType) {
        this.dialectSQLBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType);
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
    }

    public String buildQueryRangeOrderingSQL(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, QueryRange queryRange, @Nullable List<String> shardingColumnsNames) {
        return this.dialectSQLBuilder.wrapWithPageQuery(this.buildQueryRangeOrderingSQL0(qualifiedTable, columnNames, uniqueKeys, queryRange, shardingColumnsNames));
    }

    private String buildQueryRangeOrderingSQL0(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, QueryRange queryRange, @Nullable List<String> shardingColumnsNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(qualifiedTable);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        String firstUniqueKey = uniqueKeys.get(0);
        String orderByColumns = this.joinColumns(uniqueKeys, shardingColumnsNames).stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier((String)each) + " ASC").collect(Collectors.joining(", "));
        if (null != queryRange.getLower() && null != queryRange.getUpper()) {
            return String.format("SELECT %s FROM %s WHERE %s AND %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildLowerQueryRangeCondition(queryRange.isLowerInclusive(), firstUniqueKey), this.buildUpperQueryRangeCondition(firstUniqueKey), orderByColumns);
        }
        if (null != queryRange.getLower()) {
            return String.format("SELECT %s FROM %s WHERE %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildLowerQueryRangeCondition(queryRange.isLowerInclusive(), firstUniqueKey), orderByColumns);
        }
        if (null != queryRange.getUpper()) {
            return String.format("SELECT %s FROM %s WHERE %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildUpperQueryRangeCondition(firstUniqueKey), orderByColumns);
        }
        return String.format("SELECT %s FROM %s ORDER BY %s", queryColumns, qualifiedTableName, orderByColumns);
    }

    private String buildLowerQueryRangeCondition(boolean inclusive, String firstUniqueKey) {
        String delimiter = inclusive ? ">=?" : ">?";
        return this.sqlSegmentBuilder.getEscapedIdentifier(firstUniqueKey) + delimiter;
    }

    private String buildUpperQueryRangeCondition(String firstUniqueKey) {
        return this.sqlSegmentBuilder.getEscapedIdentifier(firstUniqueKey) + "<=?";
    }

    public String buildPointQuerySQL(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, @Nullable List<String> shardingColumnsNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(qualifiedTable);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        String equalsConditions = this.joinColumns(uniqueKeys, shardingColumnsNames).stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier((String)each) + "=?").collect(Collectors.joining(" AND "));
        return String.format("SELECT %s FROM %s WHERE %s", queryColumns, qualifiedTableName, equalsConditions);
    }

    private List<String> joinColumns(List<String> uniqueKeys, @Nullable List<String> shardingColumnsNames) {
        if (null == shardingColumnsNames || shardingColumnsNames.isEmpty()) {
            return uniqueKeys;
        }
        ArrayList<String> result = new ArrayList<String>(uniqueKeys.size() + shardingColumnsNames.size());
        result.addAll(uniqueKeys);
        result.addAll(shardingColumnsNames);
        return result;
    }

    public Optional<String> buildCRC32SQL(QualifiedTable qualifiedTable, String columnName) {
        return this.dialectSQLBuilder.buildCRC32SQL(this.sqlSegmentBuilder.getQualifiedTableName(qualifiedTable), this.sqlSegmentBuilder.getEscapedIdentifier(columnName));
    }
}

