/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client;

import com.google.common.primitives.Bytes;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import lombok.Generated;

public final class PasswordEncryption {
    public static byte[] encryptWithMySQL41(byte[] password, byte[] seed) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] passwordSha1 = messageDigest.digest(password);
        byte[] concatSeed = PasswordEncryption.concatSeed(messageDigest, seed, messageDigest.digest(passwordSha1));
        return PasswordEncryption.xor(passwordSha1, concatSeed, concatSeed.length);
    }

    public static byte[] encryptWithSha2(byte[] password, byte[] seed) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] s1 = messageDigest.digest(password);
        byte[] s2 = messageDigest.digest(s1);
        messageDigest.reset();
        messageDigest.update(s2);
        messageDigest.update(seed);
        byte[] s3 = messageDigest.digest();
        messageDigest.reset();
        return PasswordEncryption.xor(s1, s3, s3.length);
    }

    public static byte[] encryptWithRSAPublicKey(String password, byte[] seed, String transformation, String publicKey) {
        byte[] byArray;
        if (null == password) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 0;
        } else {
            byArray = Bytes.concat((byte[][])new byte[][]{password.getBytes(), {0}});
        }
        byte[] formattedPassword = byArray;
        return PasswordEncryption.encryptWithRSAPublicKey(PasswordEncryption.xor(formattedPassword, seed, formattedPassword.length), PasswordEncryption.parseRSAPublicKey(publicKey), transformation);
    }

    private static byte[] encryptWithRSAPublicKey(byte[] source, RSAPublicKey key, String transformation) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(transformation);
        cipher.init(1, key);
        return cipher.doFinal(source);
    }

    private static RSAPublicKey parseRSAPublicKey(String key) throws GeneralSecurityException {
        byte[] certificateData = Base64.getDecoder().decode(PasswordEncryption.formatKey(key));
        X509EncodedKeySpec spec = new X509EncodedKeySpec(certificateData);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)kf.generatePublic(spec);
    }

    private static byte[] formatKey(String key) {
        return key.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").trim().replace("\n", "").getBytes();
    }

    private static byte[] concatSeed(MessageDigest messageDigest, byte[] seed, byte[] passwordSha1) {
        messageDigest.update(seed);
        messageDigest.update(passwordSha1);
        return messageDigest.digest();
    }

    private static byte[] xor(byte[] data, byte[] seed, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(seed[i] ^ data[i]);
        }
        return result;
    }

    @Generated
    private PasswordEncryption() {
    }
}

