/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.config.checker;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.resource.storageunit.DuplicateStorageUnitException;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDataSourceConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.YamlProxyDatabaseConfiguration;

public final class YamlProxyConfigurationChecker {
    public static void checkDataSources(Map<String, YamlProxyDataSourceConfiguration> globalDataSources, Collection<YamlProxyDatabaseConfiguration> databaseConfigs) {
        databaseConfigs.forEach(each -> YamlProxyConfigurationChecker.checkDataSources(globalDataSources, each.getDataSources(), each.getDatabaseName()));
    }

    private static void checkDataSources(Map<String, YamlProxyDataSourceConfiguration> globalDataSources, Map<String, YamlProxyDataSourceConfiguration> databaseDataSources, String databaseName) {
        Collection duplicatedDataSourceNames = globalDataSources.keySet().stream().filter(databaseDataSources.keySet()::contains).collect(Collectors.toSet());
        ShardingSpherePreconditions.checkMustEmpty((Collection)duplicatedDataSourceNames, () -> new DuplicateStorageUnitException(databaseName, duplicatedDataSourceNames));
    }

    @Generated
    private YamlProxyConfigurationChecker() {
    }
}

