/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone;

import java.sql.SQLException;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.PersistRepositoryConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.standalone.lock.StandaloneLockContext;
import org.apache.shardingsphere.mode.manager.standalone.workerid.StandaloneWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.standalone.StandalonePersistRepository;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class StandaloneContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter param, EventBusContext eventBusContext) throws SQLException {
        PersistRepositoryConfiguration repositoryConfig = param.getModeConfiguration().getRepository();
        StandalonePersistRepository repository = (StandalonePersistRepository)TypedSPILoader.getService(StandalonePersistRepository.class, (Object)(null == repositoryConfig ? null : repositoryConfig.getType()), (Properties)(null == repositoryConfig ? new Properties() : repositoryConfig.getProps()));
        MetaDataPersistService persistService = new MetaDataPersistService((PersistRepository)repository);
        ComputeNodeInstanceContext computeNodeInstanceContext = new ComputeNodeInstanceContext(new ComputeNodeInstance(param.getInstanceMetaData()), param.getModeConfiguration(), eventBusContext);
        computeNodeInstanceContext.init((WorkerIdGenerator)new StandaloneWorkerIdGenerator(), (LockContext)new StandaloneLockContext());
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)persistService, (ContextManagerBuilderParameter)param, (ComputeNodeInstanceContext)computeNodeInstanceContext);
        return new ContextManager(metaDataContexts, computeNodeInstanceContext, (PersistRepository)repository);
    }

    public String getType() {
        return "Standalone";
    }

    public boolean isDefault() {
        return true;
    }
}

