/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineInternalException;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.DialectIncrementalPositionManager;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.WALPosition;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.PostgreSQLLogSequenceNumber;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.position.slot.PostgreSQLSlotManager;
import org.postgresql.replication.LogSequenceNumber;

public final class PostgreSQLIncrementalPositionManager
implements DialectIncrementalPositionManager {
    private final PostgreSQLSlotManager slotManager = new PostgreSQLSlotManager("test_decoding");

    public WALPosition init(String data) {
        return new WALPosition(new PostgreSQLLogSequenceNumber(LogSequenceNumber.valueOf((String)data)));
    }

    public WALPosition init(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.slotManager.create(connection, slotNameSuffix);
            WALPosition wALPosition = this.getWALPosition(connection, this.getLogSequenceNumberSQL(connection.getMetaData()));
            return wALPosition;
        }
    }

    private WALPosition getWALPosition(Connection connection, String logSequenceNumberSQL) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(logSequenceNumberSQL);){
            WALPosition wALPosition;
            block12: {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    resultSet.next();
                    wALPosition = new WALPosition(new PostgreSQLLogSequenceNumber(LogSequenceNumber.valueOf((String)resultSet.getString(1))));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return wALPosition;
        }
    }

    private String getLogSequenceNumberSQL(DatabaseMetaData metaData) throws SQLException {
        if (9 == metaData.getDatabaseMajorVersion() && 6 <= metaData.getDatabaseMinorVersion()) {
            return "SELECT PG_CURRENT_XLOG_LOCATION()";
        }
        if (10 <= metaData.getDatabaseMajorVersion()) {
            return "SELECT PG_CURRENT_WAL_LSN()";
        }
        throw new PipelineInternalException("Unsupported PostgreSQL version: " + metaData.getDatabaseProductVersion(), new Object[0]);
    }

    public void destroy(DataSource dataSource, String slotNameSuffix) throws SQLException {
        try (Connection connection = dataSource.getConnection();){
            this.slotManager.dropIfExisted(connection, slotNameSuffix);
        }
    }

    public String getDatabaseType() {
        return "PostgreSQL";
    }
}

