/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.narayana.manager;

import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.internal.arjuna.recovery.AtomicActionRecoveryModule;
import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
import com.arjuna.ats.jbossatx.jta.RecoveryManagerService;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.recovery.XAResourceRecoveryHelper;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import java.util.concurrent.ConcurrentMap;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.reflection.ReflectionUtils;
import org.apache.shardingsphere.transaction.exception.CloseTransactionManagerFailedException;
import org.apache.shardingsphere.transaction.xa.narayana.manager.DataSourceXAResourceRecoveryHelper;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;

public final class NarayanaXATransactionManagerProvider
implements XATransactionManagerProvider {
    private TransactionManager transactionManager;
    private XARecoveryModule xaRecoveryModule;
    private RecoveryManagerService recoveryManagerService;

    public void init() {
        this.transactionManager = jtaPropertyManager.getJTAEnvironmentBean().getTransactionManager();
        this.xaRecoveryModule = XARecoveryModule.getRegisteredXARecoveryModule();
        this.recoveryManagerService = new RecoveryManagerService();
        this.recoveryManagerService.create();
        this.recoveryManagerService.start();
    }

    public void registerRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        if (null != this.xaRecoveryModule) {
            this.xaRecoveryModule.addXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
        }
    }

    public void removeRecoveryResource(String dataSourceName, XADataSource xaDataSource) {
        if (null != this.xaRecoveryModule) {
            this.xaRecoveryModule.removeXAResourceRecoveryHelper((XAResourceRecoveryHelper)new DataSourceXAResourceRecoveryHelper(xaDataSource));
        }
    }

    public void enlistResource(SingleXAResource singleXAResource) {
        this.transactionManager.getTransaction().enlistResource(singleXAResource.getDelegate());
    }

    public void close() {
        try {
            this.recoveryManagerService.stop();
        }
        catch (Exception ex) {
            throw new CloseTransactionManagerFailedException(ex);
        }
        this.recoveryManagerService.destroy();
        this.cleanPropertiesFactory();
        this.cleanBeanInstances();
        this.cleanAtomicActionRecovery();
        this.cleanXARecoveryModule();
        this.cleanStoreManager();
    }

    private void cleanPropertiesFactory() {
        ReflectionUtils.setStaticFieldValue(PropertiesFactory.class, (String)"delegatePropertiesFactory", null);
    }

    private void cleanBeanInstances() {
        ((ConcurrentMap)ReflectionUtils.getStaticFieldValue(BeanPopulator.class, (String)"beanInstances")).clear();
    }

    private void cleanAtomicActionRecovery() {
        ReflectionUtils.setStaticFieldValue(AtomicActionRecoveryModule.class, (String)"_recoveryStore", null);
    }

    private void cleanXARecoveryModule() {
        ReflectionUtils.setStaticFieldValue(XARecoveryModule.class, (String)"registeredXARecoveryModule", null);
    }

    private void cleanStoreManager() {
        ReflectionUtils.setStaticFieldValue(StoreManager.class, (String)"actionStore", null);
        ReflectionUtils.setStaticFieldValue(StoreManager.class, (String)"stateStore", null);
        ReflectionUtils.setStaticFieldValue(StoreManager.class, (String)"communicationStore", null);
    }

    public String getType() {
        return "Narayana";
    }

    @Generated
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

