/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.service.metadata.schema;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.manager.GenericSchemaManager;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.metadata.persist.service.metadata.table.TableMetaDataPersistService;
import org.apache.shardingsphere.metadata.persist.service.metadata.table.ViewMetaDataPersistService;
import org.apache.shardingsphere.metadata.persist.service.version.MetaDataVersionPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class SchemaMetaDataPersistService {
    private final PersistRepository repository;
    private final TableMetaDataPersistService tableMetaDataPersistService;
    private final ViewMetaDataPersistService viewMetaDataPersistService;

    public SchemaMetaDataPersistService(PersistRepository repository, MetaDataVersionPersistService metaDataVersionPersistService) {
        this.repository = repository;
        this.tableMetaDataPersistService = new TableMetaDataPersistService(repository, metaDataVersionPersistService);
        this.viewMetaDataPersistService = new ViewMetaDataPersistService(repository, metaDataVersionPersistService);
    }

    public void add(String databaseName, String schemaName) {
        this.repository.persist(DatabaseMetaDataNode.getMetaDataTablesPath(databaseName, schemaName), "");
    }

    public void drop(String databaseName, String schemaName) {
        this.repository.delete(DatabaseMetaDataNode.getMetaDataSchemaPath(databaseName, schemaName));
    }

    public void alterByRefresh(String databaseName, ShardingSphereSchema schema) {
        String schemaName = schema.getName().toLowerCase();
        if (schema.getTables().isEmpty() && schema.getViews().isEmpty()) {
            this.add(databaseName, schemaName);
        }
        Map<String, ShardingSphereTable> currentTables = this.tableMetaDataPersistService.load(databaseName, schemaName);
        this.tableMetaDataPersistService.persist(databaseName, schemaName, GenericSchemaManager.getToBeAddedTables((Map)schema.getTables(), currentTables));
        GenericSchemaManager.getToBeDroppedTables((Map)schema.getTables(), currentTables).forEach((key, value) -> this.tableMetaDataPersistService.drop(databaseName, schemaName, (String)key));
    }

    public void alterByRuleAltered(String databaseName, ShardingSphereSchema schema) {
        String schemaName = schema.getName().toLowerCase();
        if (schema.getTables().isEmpty() && schema.getViews().isEmpty()) {
            this.add(databaseName, schemaName);
        }
        this.tableMetaDataPersistService.persist(databaseName, schemaName, schema.getTables());
    }

    public void alterByRuleDropped(String databaseName, String schemaName, ShardingSphereSchema schema) {
        this.tableMetaDataPersistService.persist(databaseName, schemaName, schema.getTables());
    }

    public Map<String, ShardingSphereSchema> load(String databaseName) {
        List schemaNames = this.repository.getChildrenKeys(DatabaseMetaDataNode.getMetaDataSchemasPath(databaseName));
        return schemaNames.stream().collect(Collectors.toMap(String::toLowerCase, each -> new ShardingSphereSchema(each, this.tableMetaDataPersistService.load(databaseName, (String)each), this.viewMetaDataPersistService.load(databaseName, (String)each)), (a, b) -> b, () -> new LinkedHashMap(schemaNames.size(), 1.0f)));
    }
}

