/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.logs.AnyValue;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.LogRecordBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.api.logs.Severity;
import org.apache.shardingsphere.shade.io.opentelemetry.api.trace.Span;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.AttributesMap;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LogLimits;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.LoggerSharedState;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.SdkReadWriteLogRecord;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.data.Body;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.logs.internal.AnyValueBody;

final class SdkLogRecordBuilder
implements ExtendedLogRecordBuilder {
    private final LoggerSharedState loggerSharedState;
    private final LogLimits logLimits;
    private final InstrumentationScopeInfo instrumentationScopeInfo;
    private long timestampEpochNanos;
    private long observedTimestampEpochNanos;
    @Nullable
    private Context context;
    private Severity severity = Severity.UNDEFINED_SEVERITY_NUMBER;
    @Nullable
    private String severityText;
    private Body body = Body.empty();
    @Nullable
    private AttributesMap attributes;

    SdkLogRecordBuilder(LoggerSharedState loggerSharedState, InstrumentationScopeInfo instrumentationScopeInfo) {
        this.loggerSharedState = loggerSharedState;
        this.logLimits = loggerSharedState.getLogLimits();
        this.instrumentationScopeInfo = instrumentationScopeInfo;
    }

    @Override
    public SdkLogRecordBuilder setTimestamp(long timestamp, TimeUnit unit) {
        this.timestampEpochNanos = unit.toNanos(timestamp);
        return this;
    }

    @Override
    public SdkLogRecordBuilder setTimestamp(Instant instant) {
        this.timestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    @Override
    public LogRecordBuilder setObservedTimestamp(long timestamp, TimeUnit unit) {
        this.observedTimestampEpochNanos = unit.toNanos(timestamp);
        return this;
    }

    @Override
    public LogRecordBuilder setObservedTimestamp(Instant instant) {
        this.observedTimestampEpochNanos = TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano();
        return this;
    }

    @Override
    public SdkLogRecordBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setSeverityText(String severityText) {
        this.severityText = severityText;
        return this;
    }

    @Override
    public SdkLogRecordBuilder setBody(String body) {
        this.body = AnyValueBody.create(AnyValue.of(body));
        return this;
    }

    @Override
    public LogRecordBuilder setBody(AnyValue<?> value) {
        this.body = AnyValueBody.create(value);
        return this;
    }

    @Override
    public <T> SdkLogRecordBuilder setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = AttributesMap.create(this.logLimits.getMaxNumberOfAttributes(), this.logLimits.getMaxAttributeValueLength());
        }
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public void emit() {
        if (this.loggerSharedState.hasBeenShutdown()) {
            return;
        }
        Context context = this.context == null ? Context.current() : this.context;
        long observedTimestampEpochNanos = this.observedTimestampEpochNanos == 0L ? this.loggerSharedState.getClock().now() : this.observedTimestampEpochNanos;
        this.loggerSharedState.getLogRecordProcessor().onEmit(context, SdkReadWriteLogRecord.create(this.loggerSharedState.getLogLimits(), this.loggerSharedState.getResource(), this.instrumentationScopeInfo, this.timestampEpochNanos, observedTimestampEpochNanos, Span.fromContext(context).getSpanContext(), this.severity, this.severityText, this.body, this.attributes));
    }
}

