/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpConfigUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.OpenTelemetrySdk;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.internal.AutoConfigureListener;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterProvider
implements ConfigurableSpanExporterProvider,
AutoConfigureListener {
    private final AtomicReference<MeterProvider> meterProviderRef = new AtomicReference<MeterProvider>(MeterProvider.noop());

    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("traces", config);
        if (protocol.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder builder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder builder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", config, builder::setEndpoint, builder::addHeader, builder::setCompression, builder::setTimeout, builder::setTrustedCertificates, builder::setClientTls, builder::setRetryPolicy, builder::setMemoryMode);
            builder.setMeterProvider(this.meterProviderRef::get);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + protocol);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }

    @Override
    public void afterAutoConfigure(OpenTelemetrySdk sdk) {
        this.meterProviderRef.set(sdk.getMeterProvider());
    }
}

