/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.loader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.loader.SchemaListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SchemaListenerManager {
    @Autowired(required=false)
    private List<SchemaListener> schemaListenerList = new ArrayList<SchemaListener>();

    public void setSchemaListenerList(List<SchemaListener> schemaListenerList) {
        this.schemaListenerList = schemaListenerList;
    }

    public void notifySchemaListener(MicroserviceMeta ... microserviceMetas) {
        ArrayList<SchemaMeta> schemaMetaList = new ArrayList<SchemaMeta>();
        for (MicroserviceMeta microserviceMeta : microserviceMetas) {
            schemaMetaList.addAll(microserviceMeta.getSchemaMetas());
        }
        this.notifySchemaListener(schemaMetaList.toArray(new SchemaMeta[schemaMetaList.size()]));
    }

    public void notifySchemaListener() {
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        this.notifySchemaListener(microserviceMeta);
    }

    public void notifySchemaListener(SchemaMeta ... schemaMetas) {
        for (SchemaListener listener : this.schemaListenerList) {
            listener.onSchemaLoaded(schemaMetas);
        }
    }

    public void notifySchemaListener(List<SchemaMeta> schemaMetaList) {
        SchemaMeta[] schemaMetas = schemaMetaList.toArray(new SchemaMeta[schemaMetaList.size()]);
        this.notifySchemaListener(schemaMetas);
    }

    public SchemaMeta ensureFindSchemaMeta(String schemaId) {
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        return microserviceMeta.ensureFindSchemaMeta(schemaId);
    }

    public Collection<SchemaMeta> getAllSchemaMeta() {
        MicroserviceMeta microserviceMeta = SCBEngine.getInstance().getProducerMicroserviceMeta();
        return microserviceMeta.getSchemaMetas();
    }
}

