/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.parameter.ParameterDescriptionRequiredValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.parameter.ParameterNameCookieCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.parameter.ParameterNameHeaderCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.parameter.ParameterNamePathCaseValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.parameter.ParameterNameQueryCaseValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.ParameterValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.MediaTypeValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ParameterValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.SchemaValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.parameter.ParameterContentValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.parameter.ParameterSchemaValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultParameterValidatorFactory
implements ParameterValidatorFactory {
    private final SchemaValidatorFactory schemaValidatorFactory;
    private final MediaTypeValidatorFactory mediaTypeValidatorFactory;

    public DefaultParameterValidatorFactory(SchemaValidatorFactory schemaValidatorFactory, MediaTypeValidatorFactory mediaTypeValidatorFactory) {
        this.schemaValidatorFactory = schemaValidatorFactory;
        this.mediaTypeValidatorFactory = mediaTypeValidatorFactory;
    }

    public List<ParameterValidator> create(FactoryOptions options) {
        ArrayList<ParameterValidator> validators = new ArrayList<ParameterValidator>();
        validators.add((ParameterValidator)new ParameterSchemaValidator(this.schemaValidatorFactory.create(options)));
        validators.add((ParameterValidator)new ParameterContentValidator(this.mediaTypeValidatorFactory.create(options)));
        this.addParameterNameCookieCaseValidator(validators, options);
        this.addParameterNameHeaderCaseValidator(validators, options);
        this.addParameterNamePathCaseValidator(validators, options);
        this.addParameterNameQueryCaseValidator(validators, options);
        this.addParameterDescriptionRequiredValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addParameterNameCookieCaseValidator(List<ParameterValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("parameter.name.cookie.case");
        if (expectedCase != null) {
            validators.add(new ParameterNameCookieCaseValidator(expectedCase));
        }
    }

    private void addParameterNameHeaderCaseValidator(List<ParameterValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("parameter.name.header.case");
        if (expectedCase != null) {
            validators.add(new ParameterNameHeaderCaseValidator(expectedCase));
        }
    }

    private void addParameterNamePathCaseValidator(List<ParameterValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("parameter.name.path.case");
        if (expectedCase != null) {
            validators.add(new ParameterNamePathCaseValidator(expectedCase));
        }
    }

    private void addParameterNameQueryCaseValidator(List<ParameterValidator> validators, FactoryOptions options) {
        String expectedCase = options.getString("parameter.name.query.case");
        if (expectedCase != null) {
            validators.add(new ParameterNameQueryCaseValidator(expectedCase));
        }
    }

    private void addParameterDescriptionRequiredValidator(List<ParameterValidator> validators, FactoryOptions options) {
        Boolean required = options.getBoolean("parameter.description.required");
        if (Boolean.TRUE.equals(required)) {
            validators.add(new ParameterDescriptionRequiredValidator());
        }
    }
}

