/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema;

import java.util.HashMap;
import java.util.Map;

import org.apache.servicecomb.foundation.protobuf.internal.TestSchemaBase;
import org.apache.servicecomb.foundation.protobuf.internal.model.ProtobufRoot;
import org.junit.Test;

public class TestMapSchema extends TestSchemaBase {
  @Test
  public void ssMap() throws Throwable {
    Map<String, String> ssMap = new HashMap<>();
    ssMap.put("k1", "v1");
    ssMap.put("k2", "v2");
    builder.putAllSsMap(ssMap);

    check();
  }

  @Test
  public void spMap() throws Throwable {
    builder.putSpMap("k1", ProtobufRoot.User.newBuilder().setName("n1").build());
    builder.putSpMap("k2", ProtobufRoot.User.newBuilder().setName("n2").build());

    check();
  }
}
