/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition;

import io.swagger.models.Swagger;
import java.net.URL;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static String generatePackageName(MicroserviceMeta microserviceMeta, String schemaId) {
        String name = "cse.gen." + microserviceMeta.getAppId() + "." + microserviceMeta.getShortName() + "." + schemaId;
        return ClassUtils.correctClassName((String)name);
    }

    public static String swaggerToString(Swagger swagger) {
        return SwaggerUtils.swaggerToString((Swagger)swagger);
    }

    public static Swagger parseSwagger(URL url) {
        return SwaggerUtils.parseSwagger((URL)url);
    }

    public static Swagger parseSwagger(String swaggerContent) {
        Swagger swagger = SwaggerUtils.parseSwagger((String)swaggerContent);
        SwaggerUtils.validateSwagger((Swagger)swagger);
        return swagger;
    }
}

