/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultClientEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.metrics.core.meter.vertx.EndpointMeter;

public class HttpClientEndpointMeter
extends EndpointMeter {
    public static final String QUEUE_COUNT = "queueCount";
    private Id idQueueCount;

    public HttpClientEndpointMeter(Id id, DefaultEndpointMetric metric) {
        super(id, metric);
        this.idQueueCount = this.id.withTag("statistic", QUEUE_COUNT);
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, double secondInterval) {
        super.calcMeasurements(measurements, msNow, secondInterval);
        long queueCount = ((DefaultClientEndpointMetric)this.metric).getQueueCount();
        measurements.add(this.newMeasurement(this.idQueueCount, msNow, queueCount));
    }
}

