/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.invocation;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.SpectatorUtils;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.InvocationStartEvent;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.metrics.core.meter.invocation.AbstractInvocationMeter;
import org.apache.servicecomb.swagger.invocation.Response;

public abstract class AbstractInvocationMeters {
    protected Registry registry;
    private Map<String, AbstractInvocationMeter> metersMap = new ConcurrentHashMapEx();
    private int maxKeyLen = 64;

    public AbstractInvocationMeters(Registry registry) {
        this.registry = registry;
    }

    protected AbstractInvocationMeter getOrCreateMeters(Invocation invocation, Response response) {
        StringBuilder keyBuilder = new StringBuilder(this.maxKeyLen);
        String invocationName = invocation.isConsumer() && invocation.isEdge() ? "EDGE" : invocation.getInvocationType().name();
        keyBuilder.append(invocationName).append(invocation.getRealTransportName()).append(invocation.getMicroserviceQualifiedName()).append(response.getStatusCode());
        if (keyBuilder.length() > this.maxKeyLen) {
            this.maxKeyLen = keyBuilder.length();
        }
        return this.metersMap.computeIfAbsent(keyBuilder.toString(), k -> {
            Id id = this.registry.createId("servicecomb.invocation", new String[]{"role", invocationName, "transport", invocation.getRealTransportName(), "operation", invocation.getMicroserviceQualifiedName(), "status", String.valueOf(response.getStatusCode())});
            AbstractInvocationMeter meter = this.createMeter(id);
            SpectatorUtils.registerMeter((Registry)this.registry, (Meter)meter);
            return meter;
        });
    }

    protected abstract AbstractInvocationMeter createMeter(Id var1);

    public void onInvocationStart(InvocationStartEvent event) {
    }

    public void onInvocationFinish(InvocationFinishEvent event) {
        AbstractInvocationMeter meters = this.getOrCreateMeters(event.getInvocation(), event.getResponse());
        meters.onInvocationFinish(event);
    }
}

