/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.reactivex.netty.pipeline.PipelineConfigurator;

public class ByteArrayPipelineConfigurator
implements PipelineConfigurator<byte[], byte[]> {
    @Override
    public void configureNewPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ByteBuf byteBuf;
                boolean handled = false;
                if (ByteBuf.class.isAssignableFrom(msg.getClass()) && (byteBuf = (ByteBuf)msg).isReadable()) {
                    int readableBytes = byteBuf.readableBytes();
                    byte[] msgToPass = new byte[readableBytes];
                    byteBuf.readBytes(msgToPass);
                    handled = true;
                    ctx.fireChannelRead((Object)msgToPass);
                }
                if (!handled) {
                    super.channelRead(ctx, msg);
                }
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                if (msg instanceof byte[]) {
                    byte[] msgAsBytes = (byte[])msg;
                    ByteBuf byteBuf = ctx.alloc().buffer(msgAsBytes.length).writeBytes(msgAsBytes);
                    super.write(ctx, (Object)byteBuf, promise);
                } else {
                    super.write(ctx, msg, promise);
                }
            }
        }});
    }
}

