/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn;

import reactor.core.support.Assert;
import reactor.fn.Predicate;

@Deprecated
public abstract class Predicates {
    protected Predicates() {
    }

    public static <T> Predicate<T> never() {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return false;
            }
        };
    }

    public static <T> Predicate<T> always() {
        return new Predicate<T>(){

            @Override
            public boolean test(T o) {
                return true;
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> ... predicates) {
        Assert.notEmpty(predicates, "Predicate array cannot be empty.");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate p : predicates) {
                    if (p.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> negate(final Predicate<? super T> p) {
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !p.test(t);
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        Assert.notNull(p1, "Predicate 1 cannot be null.");
        Assert.notNull(p2, "Predicate 2 cannot be null.");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return p1.test(t) || p2.test(t);
            }
        };
    }

    public static <T> Predicate<T> xor(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        Assert.notNull(p1, "Predicate 1 cannot be null.");
        Assert.notNull(p2, "Predicate 2 cannot be null.");
        return new Predicate<T>(){

            @Override
            public boolean test(T t) {
                return !p1.test(t) && !p2.test(t) || p1.test(t) && p2.test(t);
            }
        };
    }
}

