/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.bizkeeper;

import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixInvokable;
import com.netflix.hystrix.HystrixObservable;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import org.apache.servicecomb.bizkeeper.BizkeeperCommand;
import org.apache.servicecomb.bizkeeper.BizkeeperHandlerDelegate;
import org.apache.servicecomb.bizkeeper.HystrixPropertiesStrategyExt;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.ExceptionUtils;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public abstract class BizkeeperHandler
implements Handler {
    private static final Logger LOG = LoggerFactory.getLogger(BizkeeperHandler.class);
    protected final String groupname;
    private BizkeeperHandlerDelegate delegate;

    public BizkeeperHandler(String groupname) {
        this.groupname = groupname;
        this.delegate = new BizkeeperHandlerDelegate(this);
    }

    protected abstract BizkeeperCommand createBizkeeperCommand(Invocation var1);

    public void handle(Invocation invocation, AsyncResponse asyncResp) {
        HystrixObservable<Response> command = this.delegate.createBizkeeperCommand(invocation);
        Observable observable = command.toObservable();
        observable.subscribe(arg_0 -> ((AsyncResponse)asyncResp).complete(arg_0), error -> {
            LOG.warn("catch error in bizkeeper:" + error.getMessage());
            asyncResp.fail(invocation.getInvocationType(), error);
        }, () -> {});
    }

    protected void setCommonProperties(Invocation invocation, HystrixCommandProperties.Setter setter) {
    }

    static {
        try {
            HystrixPlugins.getInstance().registerPropertiesStrategy((HystrixPropertiesStrategy)HystrixPropertiesStrategyExt.getInstance());
        }
        catch (IllegalStateException e) {
            LOG.warn("Hystrix properties already registered. Dynamic configuration may not work.", (Throwable)e);
        }
        try {
            HystrixPlugins.getInstance().registerCommandExecutionHook(new HystrixCommandExecutionHook(){

                public <T> Exception onExecutionError(HystrixInvokable<T> commandInstance, Exception e) {
                    LOG.warn("bizkeeper execution error, info={}", (Object)ExceptionUtils.getExceptionMessageWithoutTrace((Throwable)e));
                    return e;
                }
            });
        }
        catch (IllegalStateException e) {
            LOG.warn("HystrixCommandExecutionHook already registered.", (Throwable)e);
        }
    }
}

