/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCIterator;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.point.NestedCollectionIteratorAdapter;
import ucar.nc2.ft.point.PointFeatureCCCImpl;
import ucar.nc2.ft.point.PointFeatureCCIteratorFiltered;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public abstract class StationProfileCollectionImpl
extends PointFeatureCCCImpl
implements StationProfileFeatureCollection {
    private volatile StationHelper stationHelper;
    protected PointFeatureCCIterator localIterator;

    public StationProfileCollectionImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.STATION_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StationHelper getStationHelper() {
        if (this.stationHelper == null) {
            StationProfileCollectionImpl stationProfileCollectionImpl = this;
            synchronized (stationProfileCollectionImpl) {
                if (this.stationHelper == null) {
                    try {
                        this.stationHelper = this.createStationHelper();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        assert (this.stationHelper != null) : "We screwed this up.";
        return this.stationHelper;
    }

    protected abstract StationHelper createStationHelper() throws IOException;

    @Override
    public LatLonRect getBoundingBox() {
        return this.getStationHelper().getBoundingBox();
    }

    @Override
    public List<StationFeature> getStationFeatures() {
        return this.getStationHelper().getStationFeatures();
    }

    @Override
    public List<StationFeature> getStationFeatures(List<String> stnNames) {
        return this.getStationHelper().getStationFeaturesFromNames(stnNames);
    }

    @Override
    public List<StationFeature> getStationFeatures(LatLonRect boundingBox) {
        return this.getStationHelper().getStationFeatures(boundingBox);
    }

    @Override
    public StationFeature findStationFeature(String name) {
        return this.getStationHelper().getStation(name);
    }

    @Override
    public StationProfileFeature getStationProfileFeature(StationFeature s2) {
        return (StationProfileFeature)s2;
    }

    @Override
    public StationProfileCollectionImpl subset(List<StationFeature> stations) {
        if (stations == null) {
            return this;
        }
        return new StationProfileFeatureCollectionSubset(this, stations);
    }

    @Override
    public StationProfileCollectionImpl subset(LatLonRect boundingBox) {
        return this.subset((List)this.getStationFeatures(boundingBox));
    }

    @Override
    public StationProfileFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) {
        return this.subset((List)this.getStationFeatures(boundingBox), dateRange);
    }

    @Override
    public StationProfileCollectionImpl subset(List<StationFeature> stnsWanted, CalendarDateRange dateRange) {
        if (dateRange == null) {
            return this.subset((List)stnsWanted);
        }
        ArrayList<StationFeature> subsetStations = new ArrayList<StationFeature>();
        for (StationFeature sf : stnsWanted) {
            StationProfileFeature stsf = (StationProfileFeature)sf;
            StationProfileFeature subset = stsf.subset(dateRange);
            subsetStations.add(subset);
        }
        return new StationProfileFeatureCollectionSubset(this, subsetStations);
    }

    public int compareTo(Station so) {
        return this.name.compareTo(so.getName());
    }

    @Override
    public Iterator<StationProfileFeature> iterator() {
        try {
            PointFeatureCCIterator pfIterator = this.getNestedPointFeatureCollectionIterator();
            return new NestedCollectionIteratorAdapter<StationProfileFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public StationProfileFeature next() throws IOException {
        return (StationProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getNestedPointFeatureCollectionIterator();
    }

    public static class NestedCollectionIOIteratorAdapter<T>
    implements IOIterator<T> {
        PointFeatureCCIterator pfIterator;

        public NestedCollectionIOIteratorAdapter(PointFeatureCCIterator pfIterator) {
            this.pfIterator = pfIterator;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.pfIterator.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public T next() {
            try {
                return (T)this.pfIterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.pfIterator.close();
        }
    }

    private static class StationProfileFeatureCollectionSubset
    extends StationProfileCollectionImpl {
        private final StationProfileCollectionImpl from;
        private final List<StationFeature> stations;

        StationProfileFeatureCollectionSubset(StationProfileCollectionImpl from, List<StationFeature> stations) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.stations = stations;
        }

        @Override
        protected StationHelper createStationHelper() {
            return this.from.getStationHelper().subset(this.stations);
        }

        @Override
        public PointFeatureCCIterator getNestedPointFeatureCollectionIterator() throws IOException {
            return new PointFeatureCCIteratorFiltered(this.from.getNestedPointFeatureCollectionIterator(), new Filter());
        }

        @Override
        public IOIterator<PointFeatureCC> getCollectionIterator() throws IOException {
            return new NestedCollectionIOIteratorAdapter<PointFeatureCC>(this.getNestedPointFeatureCollectionIterator());
        }

        private class Filter
        implements PointFeatureCCIterator.Filter {
            private Filter() {
            }

            @Override
            public boolean filter(PointFeatureCC pointFeatureCollection) {
                StationProfileFeature stationFeature = (StationProfileFeature)pointFeatureCollection;
                return StationProfileFeatureCollectionSubset.this.getStationHelper().getStation(stationFeature.getName()) != null;
            }
        }
    }
}

