/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.time;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.util.StringUtil2;

@Immutable
public class CalendarPeriod {
    private static final Logger log = LoggerFactory.getLogger(CalendarPeriod.class);
    private static final Cache<CalendarPeriod, CalendarPeriod> cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    public static final CalendarPeriod Hour = CalendarPeriod.of(1, Field.Hour);
    private final int value;
    private final Field field;

    public static Field fromUnitString(String udunit) {
        udunit = udunit.trim();
        if ((udunit = udunit.toLowerCase()).equals("s")) {
            return Field.Second;
        }
        if (udunit.equals("ms")) {
            return Field.Millisec;
        }
        if (udunit.endsWith("s")) {
            udunit = udunit.substring(0, udunit.length() - 1);
        }
        switch (udunit) {
            case "second": 
            case "sec": {
                return Field.Second;
            }
            case "millisecond": 
            case "millisec": 
            case "msec": {
                return Field.Millisec;
            }
            case "minute": 
            case "min": {
                return Field.Minute;
            }
            case "hour": 
            case "hr": 
            case "h": {
                return Field.Hour;
            }
            case "day": 
            case "d": {
                return Field.Day;
            }
            case "month": 
            case "mon": {
                return Field.Month;
            }
            case "year": 
            case "yr": {
                return Field.Year;
            }
        }
        throw new IllegalArgumentException("cant convert " + udunit + " to CalendarPeriod");
    }

    public static CalendarPeriod of(int value, Field field) {
        CalendarPeriod want = new CalendarPeriod(value, field);
        if (cache == null) {
            return want;
        }
        CalendarPeriod got = cache.getIfPresent(want);
        if (got != null) {
            return got;
        }
        cache.put(want, want);
        return want;
    }

    public static CalendarPeriod of(String udunit) {
        String units;
        int value;
        String[] split = StringUtil2.splitString(udunit);
        if (split.length == 1) {
            value = 1;
            units = split[0];
        } else if (split.length == 2) {
            try {
                value = Integer.parseInt(split[0]);
            }
            catch (Throwable t) {
                return null;
            }
            units = split[1];
        } else {
            return null;
        }
        Field unit = CalendarPeriod.fromUnitString(units);
        return CalendarPeriod.of(value, unit);
    }

    public static CalendarPeriod of(TimeDuration td) {
        Field unit = CalendarPeriod.fromUnitString(td.getTimeUnit().getUnitString());
        return CalendarPeriod.of((int)td.getValue(), unit);
    }

    private CalendarPeriod(int value, Field field) {
        this.value = value;
        this.field = field;
    }

    public CalendarPeriod multiply(int value) {
        return CalendarPeriod.of(this.value * value, this.field);
    }

    public int getValue() {
        return this.value;
    }

    public Field getField() {
        return this.field;
    }

    public int subtract(CalendarDate start, CalendarDate end) {
        int thislen;
        long diff = end.getDifferenceInMsecs(start);
        if (diff % (long)(thislen = this.millisecs()) != 0L) {
            log.warn("roundoff error");
        }
        return (int)(diff / (long)thislen);
    }

    public double getConvertFactor(CalendarPeriod from) {
        if (this.field == Field.Month || this.field == Field.Year) {
            log.warn(" CalendarDate.convert on Month or Year");
        }
        return (double)from.millisecs() / (double)this.millisecs();
    }

    public double getValueInMillisecs() {
        if (this.field == Field.Month) {
            return 2.592E9 * (double)this.value;
        }
        if (this.field == Field.Year) {
            return 3.1536E10 * (double)this.value;
        }
        return this.millisecs();
    }

    private int millisecs() {
        if (this.field == Field.Millisec) {
            return this.value;
        }
        if (this.field == Field.Second) {
            return 1000 * this.value;
        }
        if (this.field == Field.Minute) {
            return 60000 * this.value;
        }
        if (this.field == Field.Hour) {
            return 3600000 * this.value;
        }
        if (this.field == Field.Day) {
            return 86400000 * this.value;
        }
        throw new IllegalStateException("Illegal Field = " + (Object)((Object)this.field));
    }

    public int getOffset(CalendarDate start, CalendarDate end) {
        long end_millis;
        if (start.equals(end)) {
            return 0;
        }
        long start_millis = start.getDateTime().getMillis();
        Period p = start_millis < (end_millis = end.getDateTime().getMillis()) ? new Period(start_millis, end_millis + 5000L, this.getPeriodType()) : new Period(start_millis + 5000L, end_millis, this.getPeriodType());
        return p.get(this.getDurationFieldType());
    }

    PeriodType getPeriodType() {
        return this.getField().p;
    }

    DurationFieldType getDurationFieldType() {
        return this.getField().p.getFieldType(0);
    }

    public String toString() {
        return this.value + " " + (Object)((Object)this.field);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CalendarPeriod that = (CalendarPeriod)o;
        if (this.value != that.value) {
            return false;
        }
        return this.field == that.field;
    }

    public int hashCode() {
        int result = this.value;
        result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
        return result;
    }

    public static enum Field {
        Millisec(PeriodType.millis()),
        Second(PeriodType.seconds()),
        Minute(PeriodType.minutes()),
        Hour(PeriodType.hours()),
        Day(PeriodType.days()),
        Month(PeriodType.months()),
        Year(PeriodType.years());

        PeriodType p;

        private Field(PeriodType p) {
            this.p = p;
        }
    }
}

