/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.utils;

public class RDDSampleUtils {
    public static int getSampleNumbers(int numPartitions, long totalNumberOfRecords, int givenSampleNumbers) {
        if (givenSampleNumbers > 0) {
            if ((long)givenSampleNumbers > totalNumberOfRecords) {
                throw new IllegalArgumentException("[Sedona] Number of samples " + givenSampleNumbers + " cannot be larger than total records num " + totalNumberOfRecords);
            }
            return givenSampleNumbers;
        }
        if ((long)numPartitions > (totalNumberOfRecords + 1L) / 2L) {
            throw new IllegalArgumentException("[Sedona] Number of partitions " + numPartitions + " cannot be larger than half of total records num " + totalNumberOfRecords);
        }
        if (totalNumberOfRecords < 1000L) {
            return (int)totalNumberOfRecords;
        }
        long minSampleCnt = Math.min((long)numPartitions * 2L, totalNumberOfRecords);
        return (int)Math.max(minSampleCnt, Math.min(totalNumberOfRecords / 100L, Integer.MAX_VALUE));
    }
}

