/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.geom.Point2D;
import java.util.Map;
import java.util.Objects;
import javax.media.jai.Interpolation;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.raster.RasterAccessors;
import org.apache.sedona.common.utils.RasterUtils;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.processing.Operations;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.grid.GridGeometry;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class RasterEditors {
    public static GridCoverage2D setSrid(GridCoverage2D raster, int srid) {
        Object crs = srid == 0 ? DefaultEngineeringCRS.GENERIC_2D : FunctionsGeoTools.sridToCRS(srid);
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        MathTransform2D transform = raster.getGridGeometry().getGridToCRS2D();
        Map properties = raster.getProperties();
        GridCoverage[] sources = raster.getSources().toArray(new GridCoverage[0]);
        return gridCoverageFactory.create((CharSequence)raster.getName().toString(), raster.getRenderedImage(), (CoordinateReferenceSystem)crs, (MathTransform)transform, raster.getSampleDimensions(), sources, properties);
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, String geoRefCoords, String format) {
        AffineTransform2D affine;
        String[] coords = geoRefCoords.split(" ");
        if (coords.length != 6) {
            return null;
        }
        double scaleX = Double.parseDouble(coords[0]);
        double skewY = Double.parseDouble(coords[1]);
        double skewX = Double.parseDouble(coords[2]);
        double scaleY = Double.parseDouble(coords[3]);
        double upperLeftX = Double.parseDouble(coords[4]);
        double upperLeftY = Double.parseDouble(coords[5]);
        if (format.equalsIgnoreCase("GDAL")) {
            affine = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        } else if (format.equalsIgnoreCase("ESRI")) {
            affine = new AffineTransform2D(scaleX, skewY, skewX, scaleY, upperLeftX -= scaleX * 0.5, upperLeftY -= scaleY * 0.5);
        } else {
            throw new IllegalArgumentException("Please select between the following formats GDAL and ESRI");
        }
        int height = RasterAccessors.getHeight(raster);
        int width = RasterAccessors.getWidth(raster);
        GridGeometry2D gridGeometry2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, width, height), PixelOrientation.UPPER_LEFT, (MathTransform)affine, raster.getCoordinateReferenceSystem(), null);
        return RasterUtils.create(raster.getRenderedImage(), gridGeometry2D, raster.getSampleDimensions(), null);
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, String geoRefCoords) {
        return RasterEditors.setGeoReference(raster, geoRefCoords, "GDAL");
    }

    public static GridCoverage2D setGeoReference(GridCoverage2D raster, double upperLeftX, double upperLeftY, double scaleX, double scaleY, double skewX, double skewY) {
        String geoRedCoord = String.format("%f %f %f %f %f %f", scaleX, skewY, skewX, scaleY, upperLeftX, upperLeftY);
        return RasterEditors.setGeoReference(raster, geoRedCoord, "GDAL");
    }

    public static GridCoverage2D resample(GridCoverage2D raster, double widthOrScale, double heightOrScale, double gridX, double gridY, boolean useScale, String algorithm) throws TransformException {
        AffineTransform2D affine = RasterUtils.getGDALAffineTransform(raster);
        int originalWidth = RasterAccessors.getWidth(raster);
        int originalHeight = RasterAccessors.getHeight(raster);
        double upperLeftX = affine.getTranslateX();
        double upperLeftY = affine.getTranslateY();
        double originalSkewX = affine.getShearX();
        double originalSkewY = affine.getShearY();
        double originalScaleX = affine.getScaleX();
        double originalScaleY = affine.getScaleY();
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem2D();
        int newWidth = useScale ? originalWidth : (int)Math.floor(widthOrScale);
        int newHeight = useScale ? originalHeight : (int)Math.floor(heightOrScale);
        double newScaleX = useScale ? widthOrScale : originalScaleX;
        double newScaleY = useScale ? heightOrScale : originalScaleY;
        double newUpperLeftX = upperLeftX;
        double newUpperLeftY = upperLeftY;
        if (RasterEditors.noConfigChange(originalWidth, originalHeight, upperLeftX, upperLeftY, originalScaleX, originalScaleY, newWidth, newHeight, gridX, gridY, newScaleX, newScaleY, useScale)) {
            return raster;
        }
        Envelope2D envelope2D = raster.getEnvelope2D();
        if (!useScale) {
            newScaleX = Math.abs(envelope2D.getMaxX() - envelope2D.getMinX()) / (double)newWidth;
            newScaleY = Math.signum(originalScaleY) * Math.abs(envelope2D.getMaxY() - envelope2D.getMinY()) / (double)newHeight;
        } else {
            newWidth = (int)Math.ceil(Math.abs(envelope2D.getMaxX() - envelope2D.getMinX()) / Math.abs(newScaleX));
            newHeight = (int)Math.ceil(Math.abs(envelope2D.getMaxY() - envelope2D.getMinY()) / Math.abs(newScaleY));
        }
        if (!RasterEditors.approximateEquals(upperLeftX, gridX) || !RasterEditors.approximateEquals(upperLeftY, gridY)) {
            int[] expectedCellCoordinates;
            GridCoverage2D tempRaster = RasterEditors.setGeoReference(raster, gridX, gridY, newScaleX, newScaleY, originalSkewX, originalSkewY);
            Point2D expectedGeoPoint = RasterUtils.getWorldCornerCoordinates(tempRaster, (expectedCellCoordinates = RasterUtils.getGridCoordinatesFromWorld(tempRaster, upperLeftX, upperLeftY))[0] + 1, expectedCellCoordinates[1] + 1);
            if (!RasterEditors.approximateEquals(expectedGeoPoint.getX(), upperLeftX)) {
                if (!useScale) {
                    newScaleX = Math.abs(envelope2D.getMaxX() - expectedGeoPoint.getX()) / (double)newWidth;
                } else {
                    newWidth = (int)Math.ceil(Math.abs(envelope2D.getMaxX() - expectedGeoPoint.getX()) / Math.abs(newScaleX));
                }
                newUpperLeftX = expectedGeoPoint.getX();
            }
            if (!RasterEditors.approximateEquals(expectedGeoPoint.getY(), upperLeftY)) {
                if (!useScale) {
                    newScaleY = Math.signum(newScaleY) * Math.abs(envelope2D.getMinY() - expectedGeoPoint.getY()) / (double)newHeight;
                } else {
                    newHeight = (int)Math.ceil(Math.abs(envelope2D.getMinY() - expectedGeoPoint.getY()) / Math.abs(newScaleY));
                }
                newUpperLeftY = expectedGeoPoint.getY();
            }
        }
        AffineTransform2D transform = new AffineTransform2D(newScaleX, originalSkewY, originalSkewX, newScaleY, newUpperLeftX, newUpperLeftY);
        GridGeometry2D gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, newWidth, newHeight), PixelInCell.CELL_CORNER, (MathTransform)transform, crs, null);
        Interpolation resamplingAlgorithm = Interpolation.getInstance((int)0);
        if (!Objects.isNull(algorithm) && !algorithm.isEmpty()) {
            if (algorithm.equalsIgnoreCase("nearestneighbor")) {
                resamplingAlgorithm = Interpolation.getInstance((int)0);
            } else if (algorithm.equalsIgnoreCase("bilinear")) {
                resamplingAlgorithm = Interpolation.getInstance((int)1);
            } else if (algorithm.equalsIgnoreCase("bicubic")) {
                resamplingAlgorithm = Interpolation.getInstance((int)2);
            }
        }
        GridCoverage2D newRaster = (GridCoverage2D)Operations.DEFAULT.resample((GridCoverage)raster, null, (GridGeometry)gridGeometry, resamplingAlgorithm);
        return newRaster;
    }

    public static GridCoverage2D resample(GridCoverage2D raster, double widthOrScale, double heightOrScale, boolean useScale, String algorithm) throws TransformException {
        return RasterEditors.resample(raster, widthOrScale, heightOrScale, RasterAccessors.getUpperLeftX(raster), RasterAccessors.getUpperLeftY(raster), useScale, algorithm);
    }

    public static GridCoverage2D resample(GridCoverage2D raster, GridCoverage2D referenceRaster, boolean useScale, String algorithm) throws FactoryException, TransformException {
        int destSRID;
        int srcSRID = RasterAccessors.srid(raster);
        if (srcSRID != (destSRID = RasterAccessors.srid(referenceRaster))) {
            throw new IllegalArgumentException("Provided input raster and reference raster have different SRIDs");
        }
        double[] refRasterMetadata = RasterAccessors.metadata(referenceRaster);
        int newWidth = (int)refRasterMetadata[2];
        int newHeight = (int)refRasterMetadata[3];
        double gridX = refRasterMetadata[0];
        double gridY = refRasterMetadata[1];
        double newScaleX = refRasterMetadata[4];
        double newScaleY = refRasterMetadata[5];
        if (useScale) {
            return RasterEditors.resample(raster, newScaleX, newScaleY, gridX, gridY, useScale, algorithm);
        }
        return RasterEditors.resample(raster, newWidth, newHeight, gridX, gridY, useScale, algorithm);
    }

    private static boolean approximateEquals(double a, double b) {
        double tolerance = 1.0E-6;
        return Math.abs(a - b) <= tolerance;
    }

    private static boolean noConfigChange(int oldWidth, int oldHeight, double oldUpperX, double oldUpperY, double originalScaleX, double originalScaleY, int newWidth, int newHeight, double newUpperX, double newUpperY, double newScaleX, double newScaleY, boolean useScale) {
        if (!useScale) {
            return oldWidth == newWidth && oldHeight == newHeight && RasterEditors.approximateEquals(oldUpperX, newUpperX) && RasterEditors.approximateEquals(oldUpperY, newUpperY);
        }
        return RasterEditors.approximateEquals(originalScaleX, newScaleX) && RasterEditors.approximateEquals(originalScaleY, newScaleY) && RasterEditors.approximateEquals(oldUpperX, newUpperX) && RasterEditors.approximateEquals(oldUpperY, newUpperY);
    }
}

