/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.raster;

import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sedona_sql.io.raster.GeotiffFileWriter;
import org.apache.spark.sql.sedona_sql.io.raster.GeotiffSchema$;
import org.apache.spark.sql.sedona_sql.io.raster.ImageReadOptions;
import org.apache.spark.sql.sedona_sql.io.raster.ImageWriteOptions;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec!B\u0004\t\u0001A1\u0002\"B\u0016\u0001\t\u0003i\u0003\"\u0002\u0019\u0001\t\u0003\n\u0004\"\u00023\u0001\t\u0003*\u0007\"B;\u0001\t\u00032\b\"B<\u0001\t#B\bbBA\u001e\u0001\u0011%\u0011Q\b\u0002\u0012\u000f\u0016|G/\u001b4g\r&dWMR8s[\u0006$(BA\u0005\u000b\u0003\u0019\u0011\u0018m\u001d;fe*\u00111\u0002D\u0001\u0003S>T!!\u0004\b\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001cB\u0001A\f\u001eKA\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"AH\u0012\u000e\u0003}Q!\u0001I\u0011\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003E9\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0011z\"A\u0003$jY\u00164uN]7biB\u0011a%K\u0007\u0002O)\u0011\u0001FD\u0001\bg>,(oY3t\u0013\tQsE\u0001\nECR\f7k\\;sG\u0016\u0014VmZ5ti\u0016\u0014\u0018A\u0002\u001fj]&$hh\u0001\u0001\u0015\u00039\u0002\"a\f\u0001\u000e\u0003!\t1\"\u001b8gKJ\u001c6\r[3nCR!!gO!R!\rA2'N\u0005\u0003ie\u0011aa\u00149uS>t\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0015!\u0018\u0010]3t\u0013\tQtG\u0001\u0006TiJ,8\r\u001e+za\u0016DQ\u0001\u0010\u0002A\u0002u\nAb\u001d9be.\u001cVm]:j_:\u0004\"AP \u000e\u00039I!\u0001\u0011\b\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000b\t\u0013\u0001\u0019A\"\u0002\u000f=\u0004H/[8ogB!Ai\u0013(O\u001d\t)\u0015\n\u0005\u0002G35\tqI\u0003\u0002IY\u00051AH]8pizJ!AS\r\u0002\rA\u0013X\rZ3g\u0013\taUJA\u0002NCBT!AS\r\u0011\u0005\u0011{\u0015B\u0001)N\u0005\u0019\u0019FO]5oO\")!K\u0001a\u0001'\u0006)a-\u001b7fgB\u0019A+\u0017/\u000f\u0005U;fB\u0001$W\u0013\u0005Q\u0012B\u0001-\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002Y3A\u0011QLY\u0007\u0002=*\u0011q\fY\u0001\u0003MNT!!\u0019\n\u0002\r!\fGm\\8q\u0013\t\u0019gL\u0001\u0006GS2,7\u000b^1ukN\fA\u0002\u001d:fa\u0006\u0014Xm\u0016:ji\u0016$RAZ5keN\u0004\"AH4\n\u0005!|\"aE(viB,Ho\u0016:ji\u0016\u0014h)Y2u_JL\b\"\u0002\u001f\u0004\u0001\u0004i\u0004\"B6\u0004\u0001\u0004a\u0017a\u00016pEB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eY\u0001\n[\u0006\u0004(/\u001a3vG\u0016L!!\u001d8\u0003\u0007){'\rC\u0003C\u0007\u0001\u00071\tC\u0003u\u0007\u0001\u0007Q'\u0001\u0006eCR\f7k\u00195f[\u0006\f\u0011b\u001d5peRt\u0015-\\3\u0015\u00039\u000b1BY;jY\u0012\u0014V-\u00193feRy\u00110!\u0005\u0002\u0014\u0005U\u0011\u0011DA\u000f\u0003S\tY\u0003\u0005\u0003\u0019ur|\u0018BA>\u001a\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002\u001f{&\u0011ap\b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mKB)A+!\u0001\u0002\u0006%\u0019\u00111A.\u0003\u0011%#XM]1u_J\u0004B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017q\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005=\u0011\u0011\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003=\u000b\u0001\u0007Q\bC\u0003u\u000b\u0001\u0007Q\u0007\u0003\u0004\u0002\u0018\u0015\u0001\r!N\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"1\u00111D\u0003A\u0002U\naB]3rk&\u0014X\rZ*dQ\u0016l\u0017\rC\u0004\u0002 \u0015\u0001\r!!\t\u0002\u000f\u0019LG\u000e^3sgB!A+WA\u0012!\r1\u0013QE\u0005\u0004\u0003O9#A\u0002$jYR,'\u000fC\u0003C\u000b\u0001\u00071\tC\u0004\u0002.\u0015\u0001\r!a\f\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004Y\u0001\u0005G>tg-\u0003\u0003\u0002:\u0005M\"!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u000bjgZ\u000bG.\u001b3HK>$\u0016N\u001a4TG\",W.\u0019\u000b\u0007\u0003\u007f\t)%a\u0014\u0011\u0007a\t\t%C\u0002\u0002De\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002H\u0019\u0001\r!!\u0013\u0002#%l\u0017mZ3Xe&$Xm\u00149uS>t7\u000fE\u00020\u0003\u0017J1!!\u0014\t\u0005EIU.Y4f/JLG/Z(qi&|gn\u001d\u0005\u0006i\u001a\u0001\r!\u000e")
public class GeotiffFileFormat
implements FileFormat,
DataSourceRegister {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.supportBatch$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Option<Seq<String>> vectorTypes(StructType requiredSchema, StructType partitionSchema, SQLConf sqlConf) {
        return FileFormat.vectorTypes$((FileFormat)this, (StructType)requiredSchema, (StructType)partitionSchema, (SQLConf)sqlConf);
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return FileFormat.isSplitable$((FileFormat)this, (SparkSession)sparkSession, options, (Path)path);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.buildReaderWithPartitionValues$((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public boolean supportDataType(DataType dataType) {
        return FileFormat.supportDataType$((FileFormat)this, (DataType)dataType);
    }

    public boolean supportFieldName(String name) {
        return FileFormat.supportFieldName$((FileFormat)this, (String)name);
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)GeotiffSchema$.MODULE$.imageSchema());
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        ImageWriteOptions imageWriteOptions = new ImageWriteOptions(options);
        if (!this.isValidGeoTiffSchema(imageWriteOptions, dataSchema)) {
            throw new IllegalArgumentException("Invalid GeoTiff Schema");
        }
        return new OutputWriterFactory(null, imageWriteOptions){
            private final ImageWriteOptions imageWriteOptions$1;

            public String getFileExtension(TaskAttemptContext context) {
                return "";
            }

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new GeotiffFileWriter(path, this.imageWriteOptions$1, dataSchema, context);
            }
            {
                this.imageWriteOptions$1 = imageWriteOptions$1;
            }
        };
    }

    public String shortName() {
        return "geotiff";
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0 & Serializable)() -> "Image data source only produces a single data column named \"image\".");
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        ImageReadOptions imageSourceOptions = new ImageReadOptions(options);
        return (Function1 & Serializable)file -> {
            Iterator iterator;
            UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
            if (!imageSourceOptions.dropInvalid() && requiredSchema.isEmpty()) {
                iterator = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UnsafeRow[]{emptyUnsafeRow}));
            } else {
                Iterator filteredResult;
                byte[] byArray;
                String origin = file.filePath();
                Path path = new Path(origin);
                FileSystem fs = path.getFileSystem(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
                FSDataInputStream stream = fs.open(path);
                try {
                    byArray = ByteStreams.toByteArray((InputStream)stream);
                }
                finally {
                    Closeables.close((Closeable)stream, true);
                }
                byte[] bytes = byArray;
                Option<Row> resultOpt = GeotiffSchema$.MODULE$.decode(origin, bytes, imageSourceOptions);
                Iterator iterator2 = filteredResult = imageSourceOptions.dropInvalid() ? Option$.MODULE$.option2Iterable(resultOpt).toIterator() : package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Row[]{(Row)resultOpt.getOrElse((Function0 & Serializable)() -> GeotiffSchema$.MODULE$.invalidImageRow(origin))}));
                if (requiredSchema.isEmpty()) {
                    iterator = filteredResult.map((Function1 & Serializable)x$1 -> emptyUnsafeRow);
                } else {
                    ExpressionEncoder.Serializer converter = RowEncoder$.MODULE$.apply(requiredSchema).createSerializer();
                    iterator = filteredResult.map((Function1 & Serializable)row -> converter.apply(row));
                }
            }
            return iterator;
        };
    }

    private boolean isValidGeoTiffSchema(ImageWriteOptions imageWriteOptions, StructType dataSchema) {
        StructType schemaFields;
        String[] fields = dataSchema.fieldNames();
        return !(ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])fields), (Object)imageWriteOptions.colImage()) ? (schemaFields = (StructType)dataSchema.fields()[dataSchema.fieldIndex(imageWriteOptions.colImage())].dataType()).fieldNames().length != 6 : fields.length != 6);
    }

    public GeotiffFileFormat() {
        FileFormat.$init$((FileFormat)this);
    }
}

