/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetOutputCommitter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.codec.CodecConfig;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.GeoDataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFileFormatBase;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001\u0002\u000b\u0016\u0001\u0011B\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t\u0015\u0002\u0011\t\u0011)A\u0005\t\")1\n\u0001C\u0001\u0019\")1\n\u0001C\u0001\u001f\")\u0001\u000b\u0001C!#\")!\f\u0001C!7\")q\f\u0001C\u0001A\")!\r\u0001C!G\"9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\t9\u000b\u0001C!\u0003S;q!!-\u0016\u0011\u0003\t\u0019L\u0002\u0004\u0015+!\u0005\u0011Q\u0017\u0005\u0007\u0017:!\t!!0\t\u000f\u0005}f\u0002\"\u0001\u0002B\"9\u00111\u001a\b\u0005\n\u00055\u0007bBAu\u001d\u0011%\u00111\u001e\u0005\n\u0003ct\u0011\u0011!C\u0005\u0003g\u0014AcR3p!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$(B\u0001\f\u0018\u0003\u001d\u0001\u0018M]9vKRT!\u0001G\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00035m\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001)\u0013\u0006\f\u00197yA\u0011aeJ\u0007\u0002+%\u0011\u0001&\u0006\u0002\u0012!\u0006\u0014\u0018/^3u\r&dWMR8s[\u0006$\bC\u0001\u0014+\u0013\tYSC\u0001\rHK>\u0004\u0016M]9vKR4\u0015\u000e\\3G_Jl\u0017\r\u001e\"bg\u0016\u0004\"!\f\u0018\u000e\u0003]I!aL\f\u0003\u0015\u0019KG.\u001a$pe6\fG\u000f\u0005\u00022i5\t!G\u0003\u000247\u000591o\\;sG\u0016\u001c\u0018BA\u001b3\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005ej\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005mB$a\u0002'pO\u001eLgn\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0002\u007f\u0005)1oY1mC&\u0011\u0011I\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000egB\fG/[1m\r&dG/\u001a:\u0016\u0003\u0011\u00032!P#H\u0013\t1eH\u0001\u0004PaRLwN\u001c\t\u0003M!K!!S\u000b\u0003/\u001d+w\u000eU1scV,Go\u00159bi&\fGNR5mi\u0016\u0014\u0018AD:qCRL\u0017\r\u001c$jYR,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055s\u0005C\u0001\u0014\u0001\u0011\u0015\u00115\u00011\u0001E)\u0005i\u0015AB3rk\u0006d7\u000f\u0006\u0002S+B\u0011QhU\u0005\u0003)z\u0012qAQ8pY\u0016\fg\u000eC\u0003W\u000b\u0001\u0007q+A\u0003pi\",'\u000f\u0005\u0002>1&\u0011\u0011L\u0010\u0002\u0004\u0003:L\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003q\u0003\"!P/\n\u0005ys$aA%oi\u0006)r/\u001b;i'B\fG/[1m!J,G-[2bi\u0016\u001cHCA'b\u0011\u0015\u0011u\u00011\u0001H\u0003-IgNZ3s'\u000eDW-\\1\u0015\u000b\u0011\\\u0017/a\u0001\u0011\u0007u*U\r\u0005\u0002gS6\tqM\u0003\u0002i7\u0005)A/\u001f9fg&\u0011!n\u001a\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\"\u00027\t\u0001\u0004i\u0017\u0001D:qCJ\\7+Z:tS>t\u0007C\u00018p\u001b\u0005Y\u0012B\u00019\u001c\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015\u0011\b\u00021\u0001t\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005inthP\u0004\u0002vsB\u0011aOP\u0007\u0002o*\u0011\u0001pI\u0001\u0007yI|w\u000e\u001e \n\u0005it\u0014A\u0002)sK\u0012,g-\u0003\u0002}{\n\u0019Q*\u00199\u000b\u0005it\u0004C\u0001;\u0000\u0013\r\t\t! \u0002\u0007'R\u0014\u0018N\\4\t\u000f\u0005\u0015\u0001\u00021\u0001\u0002\b\u0005)a-\u001b7fgB1\u0011\u0011BA\n\u00033qA!a\u0003\u0002\u00109\u0019a/!\u0004\n\u0003}J1!!\u0005?\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0006\u0002\u0018\t\u00191+Z9\u000b\u0007\u0005Ea\b\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0005\u0019\u001c(bAA\u0012?\u00051\u0001.\u00193p_BLA!a\n\u0002\u001e\tQa)\u001b7f'R\fG/^:\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u0015\u00055\u00121GA\u001b\u0003\u000b\nI\u0005E\u0002.\u0003_I1!!\r\u0018\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015a\u0017\u00021\u0001n\u0011\u001d\t9$\u0003a\u0001\u0003s\t1A[8c!\u0011\tY$!\u0011\u000e\u0005\u0005u\"\u0002BA \u0003C\t\u0011\"\\1qe\u0016$WoY3\n\t\u0005\r\u0013Q\b\u0002\u0004\u0015>\u0014\u0007BBA$\u0013\u0001\u00071/A\u0004paRLwN\\:\t\r\u0005-\u0013\u00021\u0001f\u0003)!\u0017\r^1TG\",W.Y\u0001\u001fEVLG\u000e\u001a*fC\u0012,'oV5uQB\u000b'\u000f^5uS>tg+\u00197vKN$\u0002#!\u0015\u0002p\u0005E\u00141OA<\u0003w\n9)!#\u0011\u000fu\n\u0019&a\u0016\u0002^%\u0019\u0011Q\u000b \u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u0017\u0002Z%\u0019\u00111L\f\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u0004b!!\u0003\u0002`\u0005\r\u0014\u0002BA1\u0003/\u0011\u0001\"\u0013;fe\u0006$xN\u001d\t\u0005\u0003K\nY'\u0004\u0002\u0002h)\u0019\u0011\u0011N\u000e\u0002\u0011\r\fG/\u00197zgRLA!!\u001c\u0002h\tY\u0011J\u001c;fe:\fGNU8x\u0011\u0015a'\u00021\u0001n\u0011\u0019\tYE\u0003a\u0001K\"1\u0011Q\u000f\u0006A\u0002\u0015\fq\u0002]1si&$\u0018n\u001c8TG\",W.\u0019\u0005\u0007\u0003sR\u0001\u0019A3\u0002\u001dI,\u0017/^5sK\u0012\u001c6\r[3nC\"9\u0011Q\u0010\u0006A\u0002\u0005}\u0014a\u00024jYR,'o\u001d\t\u0007\u0003\u0013\t\u0019\"!!\u0011\u0007E\n\u0019)C\u0002\u0002\u0006J\u0012aAR5mi\u0016\u0014\bBBA$\u0015\u0001\u00071\u000fC\u0004\u0002\f*\u0001\r!!$\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*!\t\u0002\t\r|gNZ\u0005\u0005\u0003/\u000b\tJA\u0007D_:4\u0017nZ;sCRLwN\\\u0001\u0010gV\u0004\bo\u001c:u\t\u0006$\u0018\rV=qKR\u0019!+!(\t\u000f\u0005}5\u00021\u0001\u0002\"\u0006AA-\u0019;b)f\u0004X\rE\u0002g\u0003GK1!!*h\u0005!!\u0015\r^1UsB,\u0017\u0001D:vaB|'\u000f\u001e\"bi\u000eDG#\u0002*\u0002,\u00065\u0006\"\u00027\r\u0001\u0004i\u0007BBAX\u0019\u0001\u0007Q-\u0001\u0004tG\",W.Y\u0001\u0015\u000f\u0016|\u0007+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u0011\u0005\u0019r1#\u0002\b\u00028Zb\u0004cA\u001f\u0002:&\u0019\u00111\u0018 \u0003\r\u0005s\u0017PU3g)\t\t\u0019,\u0001\fnKJ<WmU2iK6\f7/\u00138QCJ\fG\u000e\\3m)\u001d!\u00171YAc\u0003\u0013DQA\u001d\tA\u0002MDq!a2\u0011\u0001\u0004\t9!\u0001\u0007gS2,7\u000fV8U_V\u001c\u0007\u000eC\u0003m!\u0001\u0007Q.\u0001\u000bsK\u0006$7k\u00195f[\u00064%o\\7G_>$XM\u001d\u000b\u0006K\u0006=\u0017q\u001c\u0005\b\u0003#\f\u0002\u0019AAj\u0003\u00191wn\u001c;feB!\u0011Q[An\u001b\t\t9N\u0003\u0003\u0002$\u0005e'B\u0001\f \u0013\u0011\ti.a6\u0003\r\u0019{w\u000e^3s\u0011\u001d\t\t/\u0005a\u0001\u0003G\f\u0011bY8om\u0016\u0014H/\u001a:\u0011\u0007\u0019\n)/C\u0002\u0002hV\u0011\u0001eR3p!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe\u00069B-Z:fe&\fG.\u001b>f'\u000eDW-\\1TiJLgn\u001a\u000b\u0004I\u00065\bBBAx%\u0001\u0007a0\u0001\u0007tG\",W.Y*ue&tw-A\u0006sK\u0006$'+Z:pYZ,GCAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\fA\u0001\\1oO*\u0011\u0011q`\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0004\u0005e(AB(cU\u0016\u001cG\u000f")
public class GeoParquetFileFormat
extends ParquetFileFormat
implements GeoParquetFileFormatBase {
    private final Option<GeoParquetSpatialFilter> spatialFilter;

    public static Option<StructType> mergeSchemasInParallel(scala.collection.immutable.Map<String, String> map, Seq<FileStatus> seq, SparkSession sparkSession) {
        return GeoParquetFileFormat$.MODULE$.mergeSchemasInParallel(map, seq, sparkSession);
    }

    @Override
    public String shortName() {
        return GeoParquetFileFormatBase.shortName$(this);
    }

    public Option<GeoParquetSpatialFilter> spatialFilter() {
        return this.spatialFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof GeoParquetFileFormat)) return false;
        Option<GeoParquetSpatialFilter> option = ((GeoParquetFileFormat)other).spatialFilter();
        Option<GeoParquetSpatialFilter> option2 = this.spatialFilter();
        if (option != null) {
            if (!option.equals(option2)) return false;
            return true;
        }
        if (option2 == null) return true;
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public GeoParquetFileFormat withSpatialPredicates(GeoParquetSpatialFilter spatialFilter) {
        return new GeoParquetFileFormat((Option<GeoParquetSpatialFilter>)new Some((Object)spatialFilter));
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, scala.collection.immutable.Map<String, String> parameters, Seq<FileStatus> files) {
        return GeoParquetUtils$.MODULE$.inferSchema(sparkSession, parameters, files);
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, scala.collection.immutable.Map<String, String> options, StructType dataSchema) {
        ParquetOptions parquetOptions = new ParquetOptions(options, sparkSession.sessionState().conf());
        Configuration conf = ContextUtil.getConfiguration((JobContext)job);
        Class committerClass = conf.getClass(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key(), ParquetOutputCommitter.class, OutputCommitter.class);
        if (conf.get(SQLConf$.MODULE$.PARQUET_OUTPUT_COMMITTER_CLASS().key()) == null) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Using default output committer for Parquet: ").append(ParquetOutputCommitter.class.getCanonicalName()).toString());
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Using user defined output committer for Parquet: ").append(committerClass.getCanonicalName()).toString());
        }
        conf.setClass(SQLConf$.MODULE$.OUTPUT_COMMITTER_CLASS().key(), committerClass, OutputCommitter.class);
        job.setOutputFormatClass(ParquetOutputFormat.class);
        ParquetOutputFormat.setWriteSupportClass((Job)job, ParquetWriteSupport.class);
        ParquetWriteSupport$.MODULE$.setSchema(dataSchema, conf);
        conf.set(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key(), Boolean.toString(sparkSession.sessionState().conf().writeLegacyParquetFormat()));
        conf.set(SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), sparkSession.sessionState().conf().parquetOutputTimestampType().toString());
        try {
            String fieldIdWriteEnabled = SQLConf$.MODULE$.get().getConfString("spark.sql.parquet.fieldId.write.enabled");
            conf.set("spark.sql.parquet.fieldId.write.enabled", fieldIdWriteEnabled);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        conf.set("parquet.compression", parquetOptions.compressionCodecClassName());
        if (conf.get("parquet.summary.metadata.level") == null && conf.get("parquet.enable.summary-metadata") == null) {
            conf.setEnum("parquet.summary.metadata.level", (Enum)ParquetOutputFormat.JobSummaryLevel.NONE);
        }
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel = ParquetOutputFormat.getJobSummaryLevel((Configuration)conf);
        ParquetOutputFormat.JobSummaryLevel jobSummaryLevel2 = ParquetOutputFormat.JobSummaryLevel.NONE;
        if ((jobSummaryLevel == null ? jobSummaryLevel2 != null : !jobSummaryLevel.equals(jobSummaryLevel2)) && !ParquetOutputCommitter.class.isAssignableFrom(committerClass)) {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(134).append("Committer ").append(committerClass).append(" is not a ParquetOutputCommitter and cannot").append(" create job summaries. ").append("Set Parquet option ").append("parquet.summary.metadata.level").append(" to NONE.").toString());
        }
        conf.set("parquet.write.support.class", GeoParquetWriteSupport.class.getName());
        return new OutputWriterFactory(null){

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new ParquetOutputWriter(path, context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder(8).append(CodecConfig.from((TaskAttemptContext)context).getCodec().getExtension()).append(".parquet").toString();
            }
        };
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sparkSession.sessionState().conf().nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            None$ none$;
            Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
            Path filePath = new Path(new URI(file.filePath()));
            ParquetInputSplit split = new ParquetInputSplit(filePath, file.start(), file.start() + file.length(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            FileMetaData footerFileMetaData = ParquetFileReader.readFooter((Configuration)sharedConf, (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = footerFileMetaData.getSchema();
                GeoParquetFilters parquetFilters = new GeoParquetFilters(parquetSchema, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter((Filter)x$2)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            boolean shouldScanFile = GeoParquetMetaData$.MODULE$.parseKeyValueMetaData(footerFileMetaData.getKeyValueMetaData()).forall((Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)GeoParquetFileFormat.$anonfun$buildReaderWithPartitionValues$5(this, metadata)));
            if (!shouldScanFile) {
                iterator = ((IterableLike)Nil$.MODULE$).iterator();
            } else {
                ParquetRecordReader parquetRecordReader;
                None$ convertTz = timestampConversion && !GeoParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
                Map map = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value datetimeRebaseMode = GeoDataSourceUtils$.MODULE$.datetimeRebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_REBASE_MODE_IN_READ()));
                Map map2 = footerFileMetaData.getKeyValueMetaData();
                Enumeration.Value int96RebaseMode = GeoDataSourceUtils$.MODULE$.int96RebaseMode((Function1<String, String>)(Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), SQLConf$.MODULE$.get().getConfString(GeoDataSourceUtils$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ()));
                TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
                TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(((SerializableConfiguration)broadcastedHadoopConf.value()).value(), attemptId);
                if (pushed.isDefined()) {
                    ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
                }
                Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
                if (enableVectorizedReader) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> "GeoParquet currently does not support vectorized reader. Falling back to parquet-mr");
                }
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                GeoParquetReadSupport readSupport = new GeoParquetReadSupport((Option<ZoneId>)convertTz, false, datetimeRebaseMode, int96RebaseMode);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator((RecordReader)reader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                UnsafeProjection unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                if (partitionSchema.length() == 0) {
                    iterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return iterator;
        };
    }

    public boolean supportDataType(DataType dataType) {
        return super.supportDataType(dataType);
    }

    public boolean supportBatch(SparkSession sparkSession, StructType schema) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$5(GeoParquetFileFormat $this, GeoParquetMetaData metadata) {
        return $this.spatialFilter().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.evaluate(metadata.columns())));
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public GeoParquetFileFormat(Option<GeoParquetSpatialFilter> spatialFilter) {
        this.spatialFilter = spatialFilter;
        GeoParquetFileFormatBase.$init$(this);
    }

    public GeoParquetFileFormat() {
        this((Option<GeoParquetSpatialFilter>)None$.MODULE$);
    }
}

