/*
 * Decompiled with CFR 0.152.
 */
package ucar.units;

import javax.annotation.concurrent.Immutable;
import ucar.units.ConversionException;
import ucar.units.DerivableUnit;
import ucar.units.DerivedUnit;
import ucar.units.DerivedUnitImpl;
import ucar.units.DivideException;
import ucar.units.MultiplyException;
import ucar.units.OperationException;
import ucar.units.RaiseException;
import ucar.units.ScaledUnit;
import ucar.units.Unit;
import ucar.units.UnitImpl;
import ucar.units.UnitName;

@Immutable
public final class LogarithmicUnit
extends UnitImpl
implements DerivableUnit {
    private static final long serialVersionUID = 1L;
    private final double base;
    private final transient double lnBase;
    private final DerivableUnit reference;
    private final transient DerivedUnit derivedUnit;

    public LogarithmicUnit(Unit reference, double base) {
        this(reference, base, null);
    }

    public LogarithmicUnit(Unit reference, double base, UnitName id) {
        super(id);
        if (reference == null) {
            throw new NullPointerException("Null reference argument");
        }
        if (!(reference instanceof DerivableUnit)) {
            throw new IllegalArgumentException("Not a DerivableUnit: " + reference);
        }
        this.reference = (DerivableUnit)((Object)reference);
        if (base != 2.0 && base != 10.0 && base != Math.E) {
            throw new IllegalArgumentException("Invalid base: " + base);
        }
        this.base = base;
        this.lnBase = base == Math.E ? 1.0 : Math.log(base);
        this.derivedUnit = reference.getDerivedUnit();
    }

    static Unit getInstance(Unit unit, double base) {
        return new LogarithmicUnit(unit, base);
    }

    public DerivableUnit getReference() {
        return this.reference;
    }

    public double getBase() {
        return this.base;
    }

    @Override
    public Unit clone(UnitName id) {
        return new LogarithmicUnit((Unit)((Object)this.reference), this.getBase(), id);
    }

    @Override
    protected Unit myMultiplyBy(Unit that) throws MultiplyException {
        if (!that.isDimensionless()) {
            throw new MultiplyException(that);
        }
        return that instanceof ScaledUnit ? new ScaledUnit(((ScaledUnit)that).getScale(), this) : this;
    }

    @Override
    protected Unit myDivideBy(Unit that) throws DivideException {
        if (!that.isDimensionless()) {
            throw new DivideException(that);
        }
        return that instanceof ScaledUnit ? new ScaledUnit(1.0 / ((ScaledUnit)that).getScale(), this) : this;
    }

    @Override
    protected Unit myDivideInto(Unit that) throws OperationException {
        throw new DivideException(that);
    }

    @Override
    protected Unit myRaiseTo(int power) throws RaiseException {
        if (power == 0) {
            return DerivedUnitImpl.DIMENSIONLESS;
        }
        if (power == 1) {
            return this;
        }
        throw new RaiseException(this);
    }

    @Override
    public DerivedUnit getDerivedUnit() {
        return this.derivedUnit;
    }

    @Override
    public float toDerivedUnit(float amount) throws ConversionException {
        return (float)this.toDerivedUnit((double)amount);
    }

    @Override
    public double toDerivedUnit(double amount) throws ConversionException {
        return this.reference.toDerivedUnit(Math.exp(amount * this.lnBase));
    }

    @Override
    public float[] toDerivedUnit(float[] input, float[] output) throws ConversionException {
        int i = input.length;
        while (--i >= 0) {
            output[i] = (float)Math.exp((double)input[i] * this.lnBase);
        }
        return this.reference.toDerivedUnit(output, output);
    }

    @Override
    public double[] toDerivedUnit(double[] input, double[] output) throws ConversionException {
        int i = input.length;
        while (--i >= 0) {
            output[i] = Math.exp(input[i] * this.lnBase);
        }
        return this.reference.toDerivedUnit(output, output);
    }

    @Override
    public float fromDerivedUnit(float amount) throws ConversionException {
        return (float)this.fromDerivedUnit((double)amount);
    }

    @Override
    public double fromDerivedUnit(double amount) throws ConversionException {
        return Math.log(this.reference.fromDerivedUnit(amount)) / this.lnBase;
    }

    @Override
    public float[] fromDerivedUnit(float[] input, float[] output) throws ConversionException {
        this.reference.fromDerivedUnit(input, output);
        int i = input.length;
        while (--i >= 0) {
            output[i] = (float)(Math.log(output[i]) / this.lnBase);
        }
        return output;
    }

    @Override
    public double[] fromDerivedUnit(double[] input, double[] output) throws ConversionException {
        this.reference.fromDerivedUnit(input, output);
        int i = input.length;
        while (--i >= 0) {
            output[i] = (float)(Math.log(output[i]) / this.lnBase);
        }
        return output;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LogarithmicUnit)) {
            return false;
        }
        LogarithmicUnit that = (LogarithmicUnit)object;
        return this.base == that.base && this.reference.equals(that.reference);
    }

    @Override
    public int hashCode() {
        return Double.valueOf(this.base).hashCode() ^ this.getReference().hashCode();
    }

    @Override
    public boolean isDimensionless() {
        return true;
    }

    @Override
    public String toString() {
        String string = super.toString();
        return string != null ? string : this.getCanonicalString();
    }

    @Override
    public String getCanonicalString() {
        return (this.base == 2.0 ? "lb" : (this.base == Math.E ? "ln" : "lg")) + "(re " + this.getReference().toString() + ")";
    }
}

