/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.google.common.collect.Lists;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.env.EnvCommonOptions;
import org.apache.seatunnel.api.sink.SaveModeExecuteLocation;
import org.apache.seatunnel.api.sink.SaveModeExecuteWrapper;
import org.apache.seatunnel.api.sink.SaveModeHandler;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.sink.SupportSaveMode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.api.table.factory.TableSinkFactory;
import org.apache.seatunnel.api.table.factory.TableSourceFactory;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.common.config.TypesafeConfigUtils;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.core.starter.execution.PluginUtil;
import org.apache.seatunnel.core.starter.utils.ConfigBuilder;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.engine.common.exception.SeaTunnelEngineException;
import org.apache.seatunnel.engine.common.loader.SeaTunnelChildFirstClassLoader;
import org.apache.seatunnel.engine.common.utils.IdGenerator;
import org.apache.seatunnel.engine.core.classloader.ClassLoaderService;
import org.apache.seatunnel.engine.core.dag.actions.Action;
import org.apache.seatunnel.engine.core.dag.actions.SinkAction;
import org.apache.seatunnel.engine.core.dag.actions.SinkConfig;
import org.apache.seatunnel.engine.core.dag.actions.SourceAction;
import org.apache.seatunnel.engine.core.dag.actions.TransformAction;
import org.apache.seatunnel.engine.core.job.ConnectorJarIdentifier;
import org.apache.seatunnel.engine.core.parse.ConfigParserUtil;
import org.apache.seatunnel.engine.core.parse.JobConfigParser;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class MultipleTableJobConfigParser {
    private static final Logger log = LoggerFactory.getLogger(MultipleTableJobConfigParser.class);
    private final IdGenerator idGenerator;
    private final JobConfig jobConfig;
    private final List<URL> commonPluginJars;
    private final Config seaTunnelJobConfig;
    private final ReadonlyConfig envOptions;
    private final JobConfigParser fallbackParser;
    private final boolean isStartWithSavePoint;

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig) {
        this(jobDefineFilePath, idGenerator, jobConfig, Collections.emptyList(), false);
    }

    public MultipleTableJobConfigParser(Config seaTunnelJobConfig, IdGenerator idGenerator, JobConfig jobConfig) {
        this(seaTunnelJobConfig, idGenerator, jobConfig, Collections.emptyList(), false);
    }

    public MultipleTableJobConfigParser(String jobDefineFilePath, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this(jobDefineFilePath, null, idGenerator, jobConfig, commonPluginJars, isStartWithSavePoint);
    }

    public MultipleTableJobConfigParser(String jobDefineFilePath, List<String> variables, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = ConfigBuilder.of((Path)Paths.get(jobDefineFilePath, new String[0]), variables);
        this.envOptions = ReadonlyConfig.fromConfig((Config)this.seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, this, isStartWithSavePoint);
    }

    public MultipleTableJobConfigParser(Config seaTunnelJobConfig, IdGenerator idGenerator, JobConfig jobConfig, List<URL> commonPluginJars, boolean isStartWithSavePoint) {
        this.idGenerator = idGenerator;
        this.jobConfig = jobConfig;
        this.commonPluginJars = commonPluginJars;
        this.isStartWithSavePoint = isStartWithSavePoint;
        this.seaTunnelJobConfig = seaTunnelJobConfig;
        this.envOptions = ReadonlyConfig.fromConfig((Config)seaTunnelJobConfig.getConfig("env"));
        this.fallbackParser = new JobConfigParser(idGenerator, commonPluginJars, this, isStartWithSavePoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutablePair<List<Action>, Set<URL>> parse(ClassLoaderService classLoaderService) {
        this.fillJobConfigAndCommonJars();
        List sourceConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"source", Collections.emptyList());
        List transformConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"transform", Collections.emptyList());
        List sinkConfigs = TypesafeConfigUtils.getConfigList((Config)this.seaTunnelJobConfig, (String)"sink", Collections.emptyList());
        List<URL> connectorJars = this.getConnectorJarList(sourceConfigs, transformConfigs, sinkConfigs);
        if (!this.commonPluginJars.isEmpty()) {
            connectorJars.addAll(this.commonPluginJars);
        }
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        Object classLoader = classLoaderService == null ? new SeaTunnelChildFirstClassLoader(connectorJars, parentClassLoader) : classLoaderService.getClassLoader(Long.parseLong(this.jobConfig.getJobContext().getJobId()), connectorJars);
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
            ConfigParserUtil.checkGraph(sourceConfigs, transformConfigs, sinkConfigs);
            LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap = new LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>>();
            log.info("start generating all sources.");
            for (int configIndex = 0; configIndex < sourceConfigs.size(); ++configIndex) {
                Config sourceConfig = (Config)sourceConfigs.get(configIndex);
                Tuple2<String, List<Tuple2<CatalogTable, Action>>> tuple2 = this.parseSource(configIndex, sourceConfig, (ClassLoader)classLoader);
                tableWithActionMap.put((String)tuple2._1(), (List<Tuple2<CatalogTable, Action>>)tuple2._2());
            }
            log.info("start generating all transforms.");
            this.parseTransforms(transformConfigs, (ClassLoader)classLoader, tableWithActionMap);
            log.info("start generating all sinks.");
            ArrayList<Action> sinkActions = new ArrayList<Action>();
            for (int configIndex = 0; configIndex < sinkConfigs.size(); ++configIndex) {
                Config sinkConfig = (Config)sinkConfigs.get(configIndex);
                sinkActions.addAll(this.parseSink(configIndex, sinkConfig, (ClassLoader)classLoader, tableWithActionMap));
            }
            Set<URL> factoryUrls = this.getUsedFactoryUrls(sinkActions);
            ImmutablePair immutablePair = new ImmutablePair(sinkActions, factoryUrls);
            return immutablePair;
        }
        finally {
            Thread.currentThread().setContextClassLoader(parentClassLoader);
            if (classLoaderService != null) {
                classLoaderService.releaseClassLoader(Long.parseLong(this.jobConfig.getJobContext().getJobId()), connectorJars);
            }
        }
    }

    public Set<URL> getUsedFactoryUrls(List<Action> sinkActions) {
        HashSet<URL> urls = new HashSet<URL>();
        this.fillUsedFactoryUrls(sinkActions, urls);
        return urls;
    }

    private List<URL> getConnectorJarList(List<? extends Config> sourceConfigs, List<? extends Config> transformConfigs, List<? extends Config> sinkConfigs) {
        List factoryIds = Stream.concat(Stream.concat(sourceConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of((String)"seatunnel", (String)"source", (String)factory)), transformConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of((String)"seatunnel", (String)"transform", (String)factory))), sinkConfigs.stream().map(ConfigParserUtil::getFactoryId).map(factory -> PluginIdentifier.of((String)"seatunnel", (String)"sink", (String)factory))).collect(Collectors.toList());
        return new SeaTunnelSinkPluginDiscovery().getPluginJarPaths(factoryIds);
    }

    private void fillUsedFactoryUrls(List<Action> actions, Set<URL> result) {
        actions.forEach(action -> {
            result.addAll(action.getJarUrls());
            if (!action.getUpstream().isEmpty()) {
                this.fillUsedFactoryUrls(action.getUpstream(), result);
            }
        });
    }

    private void fillJobConfigAndCommonJars() {
        this.jobConfig.getJobContext().setJobMode((JobMode)this.envOptions.get(EnvCommonOptions.JOB_MODE));
        if (StringUtils.isEmpty((CharSequence)this.jobConfig.getName()) || this.jobConfig.getName().equals("SeaTunnel") || this.jobConfig.getName().equals(EnvCommonOptions.JOB_NAME.defaultValue())) {
            this.jobConfig.setName((String)this.envOptions.get(EnvCommonOptions.JOB_NAME));
        }
        this.jobConfig.getEnvOptions().putAll(this.envOptions.getSourceMap());
        this.commonPluginJars.addAll(new ArrayList(Common.getThirdPartyJars((String)this.jobConfig.getEnvOptions().getOrDefault(EnvCommonOptions.JARS.key(), "").toString()).stream().map(Path::toUri).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new SeaTunnelEngineException("the uri of jar illegal:" + uri, (Throwable)e);
            }
        }).collect(Collectors.toList())));
        log.info("add common jar in plugins :{}", this.commonPluginJars);
    }

    private static <T extends Factory> boolean isFallback(ClassLoader classLoader, Class<T> factoryClass, String factoryId, Consumer<T> virtualCreator) {
        Optional factory = FactoryUtil.discoverOptionalFactory((ClassLoader)classLoader, factoryClass, (String)factoryId);
        if (!factory.isPresent()) {
            return true;
        }
        try {
            virtualCreator.accept(factory.get());
        }
        catch (Exception e) {
            if (e instanceof UnsupportedOperationException && "The Factory has not been implemented and the deprecated Plugin will be used.".equals(e.getMessage())) {
                log.warn("The Factory has not been implemented and the deprecated Plugin will be used.");
                return true;
            }
            log.debug(ExceptionUtils.getMessage((Throwable)e));
        }
        return false;
    }

    private int getParallelism(ReadonlyConfig config) {
        return Math.max(1, (Integer)config.getOptional(CommonOptions.PARALLELISM).orElse(this.envOptions.get(CommonOptions.PARALLELISM)));
    }

    public Tuple2<String, List<Tuple2<CatalogTable, Action>>> parseSource(int configIndex, Config sourceConfig, ClassLoader classLoader) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)sourceConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
        int parallelism = this.getParallelism(readonlyConfig);
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSourceFactory.class, factoryId, factory -> factory.createSource(null));
        if (fallback) {
            Tuple2<CatalogTable, Action> tuple = this.fallbackParser.parseSource(sourceConfig, this.jobConfig, tableId, parallelism);
            return new Tuple2((Object)tableId, Collections.singletonList(tuple));
        }
        Tuple2 tuple2 = FactoryUtil.createAndPrepareSource((ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        HashSet<URL> factoryUrls = new HashSet<URL>();
        factoryUrls.addAll(this.getSourcePluginJarPaths(sourceConfig));
        ArrayList<Tuple2> actions = new ArrayList<Tuple2>();
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createSourceActionName(configIndex, factoryId);
        SeaTunnelSource source = (SeaTunnelSource)tuple2._1();
        source.setJobContext(this.jobConfig.getJobContext());
        PluginUtil.ensureJobModeMatch((JobContext)this.jobConfig.getJobContext(), (SeaTunnelSource)source);
        SourceAction action = new SourceAction(id, actionName, (SeaTunnelSource)tuple2._1(), factoryUrls, new HashSet<ConnectorJarIdentifier>());
        action.setParallelism(parallelism);
        for (CatalogTable catalogTable : (List)tuple2._2()) {
            actions.add(new Tuple2((Object)catalogTable, action));
        }
        return new Tuple2((Object)tableId, actions);
    }

    public void parseTransforms(List<? extends Config> transformConfigs, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        if (CollectionUtils.isEmpty(transformConfigs) || transformConfigs.isEmpty()) {
            return;
        }
        LinkedList<Config> configList = new LinkedList<Config>(transformConfigs);
        int index = 0;
        while (!configList.isEmpty()) {
            this.parseTransform(index++, configList, classLoader, tableWithActionMap);
        }
    }

    private void parseTransform(int index, Queue<Config> transforms, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        Config config = transforms.poll();
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)config);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        HashSet<URL> jarUrls = new HashSet<URL>();
        jarUrls.addAll(this.getTransformPluginJarPaths(config));
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputs = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).peek(input -> {
            if (input.size() > 1) {
                throw new JobDefineCheckException("Adding transform to multi-table source is not supported.");
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
        if (inputs.isEmpty()) {
            if (transforms.isEmpty()) {
                inputs = MultipleTableJobConfigParser.findLast(tableWithActionMap);
            } else {
                transforms.offer(config);
                return;
            }
        }
        String tableId = readonlyConfig.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
        Set inputActions = inputs.stream().map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
        MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
        int spareParallelism = ((Action)((Tuple2)inputs.get(0))._2()).getParallelism();
        int parallelism = readonlyConfig.getOptional(CommonOptions.PARALLELISM).orElse(spareParallelism);
        CatalogTable catalogTable = (CatalogTable)((Tuple2)inputs.get(0))._1();
        SeaTunnelTransform transform = FactoryUtil.createAndPrepareTransform((CatalogTable)catalogTable, (ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        transform.setJobContext(this.jobConfig.getJobContext());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createTransformActionName(index, factoryId);
        TransformAction transformAction = new TransformAction(id, actionName, new ArrayList<Action>(inputActions), transform, jarUrls, new HashSet<ConnectorJarIdentifier>());
        transformAction.setParallelism(parallelism);
        tableWithActionMap.put(tableId, Collections.singletonList(new Tuple2((Object)transform.getProducedCatalogTable(), (Object)transformAction)));
    }

    public static SeaTunnelDataType<?> getProducedType(Action action) {
        if (action instanceof SourceAction) {
            try {
                return ((CatalogTable)((SourceAction)action).getSource().getProducedCatalogTables().get(0)).getSeaTunnelRowType();
            }
            catch (UnsupportedOperationException e) {
                return ((SourceAction)action).getSource().getProducedType();
            }
        }
        if (action instanceof TransformAction) {
            return ((TransformAction)action).getTransform().getProducedCatalogTable().getSeaTunnelRowType();
        }
        throw new UnsupportedOperationException();
    }

    public static void checkProducedTypeEquals(Set<Action> inputActions) {
        SeaTunnelDataType<?> expectedType = MultipleTableJobConfigParser.getProducedType(new ArrayList<Action>(inputActions).get(0));
        for (Action action : inputActions) {
            SeaTunnelDataType<?> producedType = MultipleTableJobConfigParser.getProducedType(action);
            if (expectedType.equals(producedType)) continue;
            throw new JobDefineCheckException("Transform/Sink don't support processing data with two different structures.");
        }
    }

    @Deprecated
    private static <T> T findLast(LinkedHashMap<?, T> map) {
        int size = map.size();
        int i = 1;
        for (T value : map.values()) {
            if (i == size) {
                return value;
            }
            ++i;
        }
        return null;
    }

    public List<SinkAction<?, ?, ?, ?>> parseSink(int configIndex, Config sinkConfig, ClassLoader classLoader, LinkedHashMap<String, List<Tuple2<CatalogTable, Action>>> tableWithActionMap) {
        ReadonlyConfig readonlyConfig = ReadonlyConfig.fromConfig((Config)sinkConfig);
        String factoryId = ConfigParserUtil.getFactoryId(readonlyConfig);
        List<String> inputIds = ConfigParserUtil.getInputIds(readonlyConfig);
        List<Object> inputVertices = inputIds.stream().map(tableWithActionMap::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (inputVertices.isEmpty()) {
            inputVertices = Collections.singletonList(MultipleTableJobConfigParser.findLast(tableWithActionMap));
        } else if (inputVertices.size() > 1) {
            for (List inputVertex : inputVertices) {
                if (inputVertex.size() <= 1) continue;
                throw new JobDefineCheckException("Sink don't support simultaneous writing of data from multi-table source and other sources.");
            }
        }
        boolean fallback = MultipleTableJobConfigParser.isFallback(classLoader, TableSinkFactory.class, factoryId, factory -> factory.createSink(null));
        if (fallback) {
            return this.fallbackParser.parseSinks(configIndex, inputVertices, sinkConfig, this.jobConfig);
        }
        HashSet<URL> jarUrls = new HashSet<URL>();
        jarUrls.addAll(this.getSinkPluginJarPaths(sinkConfig));
        ArrayList sinkActions = new ArrayList();
        if (inputVertices.size() > 1) {
            Set inputActions = inputVertices.stream().flatMap(Collection::stream).map(Tuple2::_2).collect(Collectors.toCollection(LinkedHashSet::new));
            MultipleTableJobConfigParser.checkProducedTypeEquals(inputActions);
            Tuple2 inputActionSample = (Tuple2)((List)inputVertices.get(0)).get(0);
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)inputActionSample._1(), inputActions, readonlyConfig, classLoader, jarUrls, new HashSet<ConnectorJarIdentifier>(), factoryId, ((Action)inputActionSample._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
            return sinkActions;
        }
        for (Tuple2 tuple : (List)inputVertices.get(0)) {
            SinkAction<?, ?, ?, ?> sinkAction = this.createSinkAction((CatalogTable)tuple._1(), Collections.singleton(tuple._2()), readonlyConfig, classLoader, jarUrls, new HashSet<ConnectorJarIdentifier>(), factoryId, ((Action)tuple._2()).getParallelism(), configIndex);
            sinkActions.add(sinkAction);
        }
        Optional<SinkAction<?, ?, ?, ?>> multiTableSink = this.tryGenerateMultiTableSink(sinkActions, readonlyConfig, classLoader, factoryId, configIndex);
        return multiTableSink.map(Collections::singletonList).orElse(sinkActions);
    }

    private Optional<SinkAction<?, ?, ?, ?>> tryGenerateMultiTableSink(List<SinkAction<?, ?, ?, ?>> sinkActions, ReadonlyConfig options, ClassLoader classLoader, String factoryId, int configIndex) {
        if (sinkActions.stream().anyMatch(action -> !(action.getSink() instanceof SupportMultiTableSink))) {
            log.info("Unsupported multi table sink api, rollback to sink template");
            return Optional.empty();
        }
        HashMap sinks = new HashMap();
        Set<URL> jars = sinkActions.stream().flatMap(a -> a.getJarUrls().stream()).collect(Collectors.toSet());
        sinkActions.forEach(action -> {
            SeaTunnelSink sink = action.getSink();
            String tableId = action.getConfig().getMultipleRowTableId();
            sinks.put(tableId, sink);
        });
        SeaTunnelSink sink = FactoryUtil.createMultiTableSink(sinks, (ReadonlyConfig)options, (ClassLoader)classLoader);
        String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, "MultiTableSink");
        SinkAction multiTableAction = new SinkAction(this.idGenerator.getNextId(), actionName, sinkActions.get(0).getUpstream(), sink, jars, new HashSet<ConnectorJarIdentifier>());
        multiTableAction.setParallelism(sinkActions.get(0).getParallelism());
        return Optional.of(multiTableAction);
    }

    private SinkAction<?, ?, ?, ?> createSinkAction(CatalogTable catalogTable, Set<Action> inputActions, ReadonlyConfig readonlyConfig, ClassLoader classLoader, Set<URL> factoryUrls, Set<ConnectorJarIdentifier> connectorJarIdentifiers, String factoryId, int parallelism, int configIndex) {
        SeaTunnelSink sink = FactoryUtil.createAndPrepareSink((CatalogTable)catalogTable, (ReadonlyConfig)readonlyConfig, (ClassLoader)classLoader, (String)factoryId);
        sink.setJobContext(this.jobConfig.getJobContext());
        SinkConfig actionConfig = new SinkConfig(catalogTable.getTableId().toTablePath().toString());
        long id = this.idGenerator.getNextId();
        String actionName = JobConfigParser.createSinkActionName(configIndex, factoryId, actionConfig.getMultipleRowTableId());
        SinkAction sinkAction = new SinkAction(id, actionName, new ArrayList<Action>(inputActions), sink, factoryUrls, connectorJarIdentifiers, actionConfig);
        if (!this.isStartWithSavePoint) {
            this.handleSaveMode(sink);
        }
        sinkAction.setParallelism(parallelism);
        return sinkAction;
    }

    public void handleSaveMode(SeaTunnelSink<?, ?, ?, ?> sink) {
        if (SupportSaveMode.class.isAssignableFrom(sink.getClass())) {
            SupportSaveMode saveModeSink = (SupportSaveMode)sink;
            if (((SaveModeExecuteLocation)this.envOptions.get(EnvCommonOptions.SAVEMODE_EXECUTE_LOCATION)).equals((Object)SaveModeExecuteLocation.CLIENT)) {
                log.warn("SaveMode execute location on CLIENT is deprecated, please use CLUSTER instead.");
                Optional saveModeHandler = saveModeSink.getSaveModeHandler();
                if (saveModeHandler.isPresent()) {
                    try (SaveModeHandler handler = (SaveModeHandler)saveModeHandler.get();){
                        handler.open();
                        new SaveModeExecuteWrapper(handler).execute();
                    }
                    catch (Exception e) {
                        throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.HANDLE_SAVE_MODE_FAILED, (Throwable)e);
                    }
                }
            }
        }
    }

    private List<URL> getSourcePluginJarPaths(Config sourceConfig) {
        SeaTunnelSourcePluginDiscovery sourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"source", (String)sourceConfig.getString("plugin_name"));
        List pluginJarPaths = sourcePluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        return pluginJarPaths;
    }

    private List<URL> getTransformPluginJarPaths(Config transformConfig) {
        SeaTunnelTransformPluginDiscovery transformPluginDiscovery = new SeaTunnelTransformPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"transform", (String)transformConfig.getString("plugin_name"));
        List pluginJarPaths = transformPluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        return pluginJarPaths;
    }

    private List<URL> getSinkPluginJarPaths(Config sinkConfig) {
        SeaTunnelSinkPluginDiscovery sinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"sink", (String)sinkConfig.getString("plugin_name"));
        List pluginJarPaths = sinkPluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        return pluginJarPaths;
    }
}

