/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSinkPluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelTransformPluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import scala.Serializable;

public class ConnectorInstanceLoader {
    private ConnectorInstanceLoader() {
        throw new IllegalStateException("Utility class");
    }

    public static ImmutablePair<SeaTunnelSource, Set<URL>> loadSourceInstance(Config sourceConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelSourcePluginDiscovery sourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"source", (String)sourceConfig.getString("plugin_name"));
        List pluginJarPaths = sourcePluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        SeaTunnelSource seaTunnelSource = (SeaTunnelSource)sourcePluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        return new ImmutablePair((Object)seaTunnelSource, new HashSet(pluginJarPaths));
    }

    public static ImmutablePair<SeaTunnelSink<SeaTunnelRow, Serializable, Serializable, Serializable>, Set<URL>> loadSinkInstance(Config sinkConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelSinkPluginDiscovery sinkPluginDiscovery = new SeaTunnelSinkPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"sink", (String)sinkConfig.getString("plugin_name"));
        List pluginJarPaths = sinkPluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        SeaTunnelSink seaTunnelSink = (SeaTunnelSink)sinkPluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        return new ImmutablePair((Object)seaTunnelSink, new HashSet(pluginJarPaths));
    }

    public static ImmutablePair<SeaTunnelTransform<?>, Set<URL>> loadTransformInstance(Config transformConfig, JobContext jobContext, List<URL> pluginJars) {
        SeaTunnelTransformPluginDiscovery transformPluginDiscovery = new SeaTunnelTransformPluginDiscovery();
        PluginIdentifier pluginIdentifier = PluginIdentifier.of((String)"seatunnel", (String)"transform", (String)transformConfig.getString("plugin_name"));
        List pluginJarPaths = transformPluginDiscovery.getPluginJarPaths((List)Lists.newArrayList((Object[])new PluginIdentifier[]{pluginIdentifier}));
        SeaTunnelTransform seaTunnelTransform = (SeaTunnelTransform)transformPluginDiscovery.createPluginInstance(pluginIdentifier, pluginJars);
        return new ImmutablePair((Object)seaTunnelTransform, new HashSet(pluginJarPaths));
    }
}

