/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.job.JobCreateReq;
import org.apache.seatunnel.app.domain.response.job.JobRes;
import org.apache.seatunnel.app.service.IJobService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/job"})
public class JobController {
    @Resource
    private IJobService jobCRUDService;

    @PostMapping(value={"/create"})
    @ApiOperation(value="Create a job, In jobDAG for inputPluginId and targetPluginId use the plugin names instead of ids.", httpMethod="POST")
    public Result<Long> createJob(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @RequestBody JobCreateReq jobCreateRequest) throws JsonProcessingException {
        return Result.success(this.jobCRUDService.createJob(userId, jobCreateRequest));
    }

    @PutMapping(value={"/update/{jobVersionId}"})
    @ApiOperation(value="Update a job, all the existing ids should be passed in the request.", httpMethod="PUT")
    public Result<Void> updateJob(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobVersionId", required=true) @PathVariable long jobVersionId, @RequestBody JobCreateReq jobCreateReq) throws JsonProcessingException {
        this.jobCRUDService.updateJob(userId, jobVersionId, jobCreateReq);
        return Result.success();
    }

    @GetMapping(value={"/get/{jobVersionId}"})
    @ApiOperation(value="Get a job detail.", httpMethod="GET")
    public Result<JobRes> getJob(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobVersionId", required=true) @PathVariable long jobVersionId) throws JsonProcessingException {
        JobRes jobRes = this.jobCRUDService.getJob(userId, jobVersionId);
        return Result.success(jobRes);
    }
}

