/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.org.codehaus.janino.util.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.shade.org.codehaus.commons.nullanalysis.Nullable;
import org.apache.seatunnel.shade.org.codehaus.janino.util.resource.Resource;
import org.apache.seatunnel.shade.org.codehaus.janino.util.resource.ResourceFinder;

public class MapResourceFinder
extends ResourceFinder {
    private final Map<String, Resource> map = new HashMap<String, Resource>();
    private long lastModified;

    public MapResourceFinder() {
    }

    public MapResourceFinder(Map<String, byte[]> map) {
        for (Map.Entry<String, byte[]> me : map.entrySet()) {
            this.addResource(me.getKey(), me.getValue());
        }
    }

    public void addResource(final String fileName, final byte[] data) {
        this.map.put(fileName, new Resource(){

            @Override
            public InputStream open() {
                return new ByteArrayInputStream(data);
            }

            @Override
            public String getFileName() {
                return fileName;
            }

            @Override
            public long lastModified() {
                return MapResourceFinder.this.lastModified;
            }
        });
    }

    public void addResource(String fileName, String data) {
        this.addResource(fileName, data.getBytes());
    }

    public void addResource(Resource resource) {
        this.map.put(resource.getFileName(), resource);
    }

    public Collection<Resource> resources() {
        return this.map.values();
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    @Nullable
    public final Resource findResource(String resourceName) {
        return this.map.get(resourceName);
    }
}

